% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.tinyVAST}
\alias{predict.tinyVAST}
\title{Predict using vector autoregressive spatio-temporal model}
\usage{
\method{predict}{tinyVAST}(
  object,
  newdata,
  remove_origdata = FALSE,
  what = c("mu_g", "p_g", "palpha_g", "pgamma_g", "pepsilon_g", "pomega_g", "pdelta_g",
    "pxi_g", "p2_g", "palpha2_g", "pgamma2_g", "pepsilon2_g", "pomega2_g", "pdelta2_g",
    "pxi2_g"),
  se.fit = FALSE,
  bias.correct = FALSE,
  ...
)
}
\arguments{
\item{object}{Output from \code{\link[=tinyVAST]{tinyVAST()}}.}

\item{newdata}{New data-frame of independent variables used to predict the response.}

\item{remove_origdata}{Whether to eliminate the original data
from the TMB object, thereby speeding up the TMB object construction.  However, this
also eliminates information about random-effect variance, and is not
appropriate when requesting predictive standard errors or epsilon
bias-correction.}

\item{what}{What REPORTed object to output, where
\code{mu_g} is the inverse-linked transformed predictor including both linear components,
\code{p_g} is the first linear predictor,
\code{palpha_g} is the first predictor from fixed covariates in \code{formula},
\code{pgamma_g} is the first predictor from random covariates in \code{formula} (e.g., splines),
\code{pomega_g} is the first predictor from spatial variation,
\code{pepsilon_g} is the first predictor from spatio-temporal variation,
\code{pxi_g} is the first predictor from spatially varying coefficients,
\code{p2_g} is the second linear predictor,
\code{palpha2_g} is the second predictor from fixed covariates in \code{formula},
\code{pgamma2_g} is the second predictor from random covariates in \code{formula} (e.g., splines),
\code{pomega2_g} is the second predictor from spatial variation,
\code{pepsilon2_g} is the second predictor from spatio-temporal variation, and
\code{pxi2_g} is the second predictor from spatially varying coefficients.}

\item{se.fit}{Calculate standard errors?}

\item{bias.correct}{whether to epsilon bias-correct the predicted value}

\item{...}{Not used.}
}
\value{
Either a vector with the prediction for each row of \code{newdata}, or a named list
with the prediction and standard error (when \code{se.fit = TRUE}).
}
\description{
Predicts values given new covariates using a \pkg{tinyVAST} model
}
