% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{gar_auth}
\alias{gar_auth}
\title{Authorize \code{googleAuthR}}
\usage{
gar_auth(
  token = NULL,
  email = NULL,
  scopes = getOption("googleAuthR.scopes.selected"),
  app = gar_oauth_app(),
  cache = gargle::gargle_oauth_cache(),
  use_oob = gargle::gargle_oob_default(),
  package = "googleAuthR"
)
}
\arguments{
\item{token}{an actual token object or the path to a valid token stored as an
\code{.rds} file}

\item{email}{An existing gargle cached email to authenticate with or TRUE to authenticate with the only email available.}

\item{scopes}{Scope of the request}

\item{app}{app as specified by \link{gar_auth_configure}}

\item{cache}{Where to store authentication tokens}

\item{use_oob}{Whether to use OOB browserless authentication}

\item{package}{The name of the package authenticating}
}
\value{
an OAuth token object, specifically a
  \code{\link[=Token-class]{Token2.0}}, invisibly
}
\description{
Wrapper of \link[gargle]{token_fetch}
}
\examples{

\dontrun{

# sets GCP project to auth through
gar_auth_configure(path="path/to/gcp-client.json")

# starts auth process with defaults
gar_auth()

# switching between auth scopes
# first time new scope manual auth, then auto if supplied email   
gar_auth(email = "your@email.com", 
         scopes = "https://www.googleapis.com/auth/drive")
         
# ... query Google Drive functions ...

gar_auth(email = "your@email.com", 
         scopes = "https://www.googleapis.com/auth/bigquery")
         
# ..query BigQuery functions ...

}

}
\seealso{
Other authentication functions: 
\code{\link{gar_attach_auto_auth}()},
\code{\link{gar_auth_service}()},
\code{\link{gar_auto_auth}()},
\code{\link{gar_gce_auth}()},
\code{\link{get_google_token}()},
\code{\link{should_skip_token_checks}()},
\code{\link{token_exists}()}
}
\concept{authentication functions}
