% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogTransform.R
\name{log_transform}
\alias{log_transform}
\title{Log transformation decision and application on data}
\usage{
log_transform(data)
}
\arguments{
\item{data}{A numeric matrix or data frame.}
}
\value{
The original data or the data transformed with log2.
}
\description{
This function evaluates the need for a log transformation based on a set of criteria
and applies a log2 transformation if necessary.
}
\examples{
file_path <- system.file("extdata",
                         "all_count_exp_test.csv",
                         package = "TransProR")
your_data <- read.csv(file_path,
                      row.names = 1)  # Assuming first column is row names (e.g., gene names)

TransformedData <- log_transform(data = your_data)

}
\author{
Dongyue Yu
}
