% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pContrib.R
\name{pContrib}
\alias{pContrib}
\title{Compute the posterior probabilities for P(m|n0) for a given prior P(m) and
observed vector n0 of locus counts}
\usage{
pContrib(n0, probs = NULL, m.prior = rep(1/m.max, m.max), m.max = 8, theta = 0)
}
\arguments{
\item{n0}{Vector of observed allele counts - same length as the number of
loci.}

\item{probs}{List of vectors with allele probabilities for each locus}

\item{m.prior}{A vector with prior probabilities (summing to 1), where the
length of \code{m.prior} determines the plausible range of m}

\item{m.max}{Derived from the length of \code{m.prior}, and if
\code{m.prior=NULL} a uniform prior is speficied by \code{m.max}:
\code{m.prior = rep(1/m.max,m.max)}.}

\item{theta}{The coancestery coefficient}
}
\value{
Returns a vector P(m|n0) for m=1,...,m.max
}
\description{
where m ranges from 1 to \eqn{m_{\max}}{\code{m.max}} and \eqn{n_0}{n0} is
the observed locus counts.
}
\details{
Computes a vector P(m|n0) evaluated over the plausible range 1,...,m.max.
}
\examples{

  ## Simulate some allele frequencies:
  freqs <-  simAlleleFreqs()
  m <- 2
  n0 <- sapply(freqs, function(px){
                            peaks = unique(sample(length(px),
                                             size = 2 * m,
                                             replace = TRUE,
                                             prob = px))
                            return(length(peaks))
                       })
  ## Compute P(m|n0) for m=1,...,4 and the sampled n0
  pContrib(n0=n0,probs=freqs,m.max=4)

}
\references{
T. Tvedebrink (2014). 'On the exact distribution of the number of 
alleles in DNA mixtures', International Journal of Legal Medicine; 128(3):427--37. 
<https://doi.org/10.1007/s00414-013-0951-3>
}
\author{
Torben Tvedebrink, James Curran
}
