% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_csgo.R
\name{scale_color_csgo}
\alias{scale_color_csgo}
\title{CSGo color palette - color}
\usage{
scale_color_csgo(discrete = TRUE, ...)
}
\arguments{
\item{discrete}{logical: if TRUE it will generate a discrete pallet otherwise a continuous palette}

\item{...}{all available options of the \code{discrete_scale} function or \code{scale_color_gradientn} both from \code{ggplot2}}
}
\value{
\code{scale_color} object
}
\description{
A color palette (color) to be used with \code{ggplot2}
}
\examples{
\dontrun{
library(CSGo)
library(ggplot2)
library(dplyr)
library(showtext)

## Loading Google fonts (https://fonts.google.com/)
font_add_google("Quantico", "quantico")

df \%>\%
 top_n(n = 10, wt = kills) \%>\%
 ggplot(aes(x = name_match, size = shots)) +
 geom_point(aes(y = kills_efficiency, color = "Kills Efficiency")) +
 geom_point(aes(y = hits_efficiency, color = "Hits Efficiency")) +
 geom_point(aes(y = hits_to_kill, color = "Hits to Kill")) +
 ggtitle("Weapon Efficiency") +
 ylab("Efficiency (\%)") +
 xlab("") +
 labs(color = "Efficiency Type", size = "Shots") +
 theme_csgo(
   text = element_text(family = "quantico"),
   panel.grid.major.x = element_line(size = .1, color = "black",linetype = 2)
 ) +
 scale_color_csgo()
 }
}
