% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_asr__dsm__adhd__hypimp_sum}
\alias{compute_mh_p_asr__dsm__adhd__hypimp_sum}
\title{Compute "Adult Self Report [Parent] (DSM-5 Oriented Scale - ADHD
Hyperactivity-Impulsivity): Sum"}
\usage{
compute_mh_p_asr__dsm__adhd__hypimp_sum(
  data,
  name = "mh_p_asr__dsm__adhd__hypimp_sum",
  max_na = 0,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_asr__dsm__adhd__hypimp_sum}
Adult Self Report [Parent] (DSM-5 Oriented Scale - ADHD
Hyperactivity-Impulsivity): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_asr__aggr__hypimp_001}
\item \code{mh_p_asr__othpr__hypimp_001}
\item \code{mh_p_asr__othpr__hypimp_002}
\item \code{mh_p_asr__othpr__hypimp_003}
\item \code{mh_p_asr__rule__hypimp_001}
\item \code{mh_p_asr__tho__hypimp_001}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 0 of 6 items missing
}
}
\examples{
\dontrun{
compute_mh_p_asr__dsm__adhd__hypimp_sum(data) |>
  select(
    any_of(c("mh_p_asr__dsm__adhd__hypimp_sum", vars_mh_p_asr__dsm__adhd__hypimp))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_asr__dsm__adhd__hypimp_nm]{compute_mh_p_asr__dsm__adhd__hypimp_nm()}}
}
