% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parModel.R
\name{MClapplyHet}
\alias{MClapplyHet}
\title{MultiCore apply of library parallel for heterogenous tasks.}
\usage{
MClapplyHet(pop, EvalGene, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{EvalGene}{Function for evaluating a gene.}

\item{lF}{Local function configuration which provides 
all functions needed in \code{EvalGene()}.}
}
\value{
Fitness vector.
}
\description{
The evaluation of the fitness of the genes of the population
is distributed to one worker on each core of the CPU of the 
local machine.
The package \code{parallel} of base R is used.
The number of cores is provided by \code{lF$Cores}.
}
\details{
Be aware that
\itemize{
\item \code{parallel::mclapply()} assumes that each function evaluation 
      needs approximately the same time.
\item Best results are obtained if 
      \code{popsize} modulo \code{cores-1} is \code{0}.
\item Does not work on Windows.
}
}
\examples{
library(parallelly) 
if (supportsMulticore()){
lFxegaGaGene$Cores<-function() {2}
pop<-xegaInitPopulation(10, lFxegaGaGene)
popnew<-MClapplyHet(pop, lFxegaGaGene$EvalGene, lFxegaGaGene)
}

}
\seealso{
Other Execution Model: 
\code{\link{MClapply}()},
\code{\link{PparLapply}()},
\code{\link{PparLapplyHet}()},
\code{\link{futureLapply}()},
\code{\link{futureLapplyHet}()}
}
\concept{Execution Model}
