% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptivityCrossover.R
\name{IACRate}
\alias{IACRate}
\title{Individually adaptive crossover rate.}
\usage{
IACRate(fit, lF)
}
\arguments{
\item{fit}{Fitness of gene.}

\item{lF}{Local configuration.}
}
\value{
Crossover rate of a gene depending on its fitness.
}
\description{
The basic idea is to apply crossover to a gene whose
             fitness is below a threshold value with higher probability 
             to give it a chance 
             to improve. The threshold value is computed by
             \code{lF$CutoffFit()*lF$CBestFitness()}.
}
\details{
The following constants are used:
        \code{lF$CrossRate1()<lF$CrossRate2()}, and 
        \code{lF$CutoffFit()} in [0, 1].
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list()
lF$CrossRate1<-parm(0.20) 
lF$CrossRate2<-parm(0.40) 
lF$CutoffFit<-parm(0.60)
lF$CBestFitness<-parm(105)
IACRate(100, lF)
IACRate(50, lF)
}
\references{
Stanhope, Stephen A. and Daida, Jason M. (1996)
  An Individually Variable Mutation-rate Strategy for Genetic Algorithms.
  In: Koza, John (Ed.)
  Late Breaking Papers at the Genetic Programming 1996 Conference.
  Stanford University Bookstore, Stanford, pp. 177-185.
  (ISBN:0-18-201-031-7)
}
\seealso{
Other Adaptive Rates: 
\code{\link{IAMRate}()}
}
\concept{Adaptive Rates}
