% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptivityCrossover.R
\name{CrossRateFactory}
\alias{CrossRateFactory}
\title{Configure the crossover function of a genetic algorithm.}
\usage{
CrossRateFactory(method = "Const")
}
\arguments{
\item{method}{A string specifying a function for the crossover rate.}
}
\value{
Crossover rate function.
}
\description{
\code{CrossRateFactory()} implements selection
             of one of the crossover rate functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error), if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "Const" returns \code{ConstCRate()}.
             \item "IV" returns \code{IACrate()}.
                   This function gives bad genes a higher cross rate.
             }
}
\examples{
f<-CrossRateFactory("Const")
f(10, list(CrossRate1=function() {0.2}))
}
\seealso{
Other Configuration: 
\code{\link{AcceptFactory}()},
\code{\link{ApplyFactory}()},
\code{\link{CoolingFactory}()},
\code{\link{MutationRateFactory}()},
\code{\link{TerminationFactory}()},
\code{\link{checkTerminationFactory}()},
\code{\link{xegaConfiguration}()},
\code{\link{xegaEvalPopulationFactory}()}
}
\concept{Configuration}
