% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tools.R
\name{wbt_new_raster_from_base}
\alias{wbt_new_raster_from_base}
\title{New raster from base}
\usage{
wbt_new_raster_from_base(
  base,
  output,
  value = "nodata",
  data_type = "float",
  cell_size = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{base}{Input base raster file.}

\item{output}{Output raster file.}

\item{value}{Constant value to fill raster with; either 'nodata' or numeric value.}

\item{data_type}{Output raster data type; options include 'double' (64-bit), 'float' (32-bit), and 'integer' (signed 16-bit) (default is 'float').}

\item{cell_size}{Optionally specified cell size of output raster. Not used when base raster is specified.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Creates a new raster using a base image.
}
\keyword{DataTools}
