% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wbt.R
\name{wbt_file_path}
\alias{wbt_file_path}
\title{Prepare File Paths for WhiteboxTools Commands}
\usage{
wbt_file_path(x, shell_quote = TRUE, delimiter = ",", check_exists = FALSE)
}
\arguments{
\item{x}{character or \code{terra} object. Vector of file paths or strings of file paths for passing as arguments to WhiteboxTools. If the object is of class \code{SpatRaster}, \code{SpatRasterCollection}, \code{SpatVector} or \code{SpatVectorProxy} the sources are extracted with \code{terra::sources()}}

\item{shell_quote}{logical. Shell quotes around result? Default: \code{TRUE}}

\item{delimiter}{character. Either \code{","} (default) or \code{";"} allowed by WhiteboxTools.}

\item{check_exists}{logical. Check if file(s) in x exist? Useful for input values. Default: \code{FALSE}}
}
\value{
character. Length 1. A safe input string for use in WhiteboxTools commands, with paths expanded and concatenated, if necessary, and optionally shell quoted.
}
\description{
Performs path expansion with \code{path.expand()} and shell quotes with \code{shQuote()} the input paths.
}
\details{
If an input vector contains \code{";"} or \code{","} this is considered, path expansion is performed on the substrings. If the input vector has length greater than \code{1}, the vector is concatenated with \code{","} or \code{";"} to create a single output string.
}
\examples{

wbt_file_path("./abc.tif")

wbt_file_path("./abc.tif;./def.tif")

wbt_file_path("./abc.tif,./def.tif")

wbt_file_path(c("./abc.tif", "./def.tif"))

wbt_file_path("~/abc.tif", shell_quote = FALSE)

wbt_file_path(c("~/abc.tif", "~/def.tif"))

}
\keyword{General}
