% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_fd8_flow_accumulation}
\alias{wbt_fd8_flow_accumulation}
\title{Fd8 flow accumulation}
\usage{
wbt_fd8_flow_accumulation(
  dem,
  output,
  out_type = "specific contributing area",
  exponent = 1.1,
  threshold = NULL,
  log = FALSE,
  clip = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{out_type}{Output type; one of 'cells', 'specific contributing area' (default), and 'catchment area'.}

\item{exponent}{Optional exponent parameter; default is 1.1.}

\item{threshold}{Optional convergence threshold parameter, in grid cells; default is infinity.}

\item{log}{Optional flag to request the output be log-transformed.}

\item{clip}{Optional flag to request clipping the display max by 1 percent.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates an FD8 flow accumulation raster from an input DEM.
}
\keyword{HydrologicalAnalysis}
