% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_depth_to_water}
\alias{wbt_depth_to_water}
\title{Depth to water}
\usage{
wbt_depth_to_water(
  dem,
  output,
  streams = NULL,
  lakes = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input raster DEM file.}

\item{output}{Name of the output raster image file.}

\item{streams}{Name of the input streams vector (optional).}

\item{lakes}{Name of the input lakes vector (optional).}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
This tool calculates cartographic depth-to-water (DTW) index.
}
\keyword{HydrologicalAnalysis}
