% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.glmnet.interaction.R
\name{SL.glmnet.interaction}
\alias{SL.glmnet.interaction}
\title{Elastic net regression with pairwise interactions}
\usage{
SL.glmnet.interaction(
  Y,
  X,
  newX,
  family,
  obsWeights,
  id,
  alpha = 1,
  nfolds = 10,
  nlambda = 100,
  useMin = TRUE,
  loss = "deviance",
  ...
)
}
\arguments{
\item{Y}{Outcome variable}

\item{X}{Covariate dataframe}

\item{newX}{Dataframe to predict the outcome}

\item{family}{"gaussian" for regression, "binomial" for binary
classification. Untested options: "multinomial" for multiple classification
or "mgaussian" for multiple response, "poisson" for non-negative outcome
with proportional mean and variance, "cox".}

\item{obsWeights}{Optional observation-level weights}

\item{id}{Optional id to group observations from the same unit (not used
currently).}

\item{alpha}{Elastic net mixing parameter, range [0, 1]. 0 = ridge regression
and 1 = lasso.}

\item{nfolds}{Number of folds for internal cross-validation to optimize lambda.}

\item{nlambda}{Number of lambda values to check, recommended to be 100 or more.}

\item{useMin}{If TRUE use lambda that minimizes risk, otherwise use 1
standard-error rule which chooses a higher penalty with performance within
one standard error of the minimum (see Breiman et al. 1984 on CART for
background).}

\item{loss}{Loss function, can be "deviance", "mse", or "mae". If family =
binomial can also be "auc" or "class" (misclassification error).}

\item{...}{Any additional arguments are passed through to cv.glmnet.}
}
\description{
Penalized regression using elastic net. Alpha = 0 corresponds to ridge
regression and alpha = 1 corresponds to Lasso. Included in the model
are pairwise interactions between covariates.

See \code{vignette("glmnet_beta", package = "glmnet")} for a nice tutorial on
glmnet.
}
