% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_transformed_transition_kernel}
\alias{mcmc_transformed_transition_kernel}
\title{Applies a bijector to the MCMC's state space}
\usage{
mcmc_transformed_transition_kernel(inner_kernel, bijector, name = NULL)
}
\arguments{
\item{inner_kernel}{\code{TransitionKernel}-like object which has a \code{target_log_prob_fn} argument.}

\item{bijector}{bijector or list of bijectors. These bijectors use \code{forward} to map the
\code{inner_kernel} state space to the state expected by \code{inner_kernel$target_log_prob_fn}.}

\item{name}{string prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., "transformed_kernel").}
}
\value{
a Monte Carlo sampling kernel
}
\description{
The transformed transition kernel enables fitting
a bijector which serves to decorrelate the Markov chain Monte Carlo (MCMC)
event dimensions thus making the chain mix faster. This is
particularly useful when the geometry of the target distribution is
unfavorable. In such cases it may take many evaluations of the
\code{target_log_prob_fn} for the chain to mix between faraway states.
}
\details{
The idea of training an affine function to decorrelate chain event dims was
presented in Parno and Marzouk (2014). Used in conjunction with the
Hamiltonian Monte Carlo transition kernel, the Parno and Marzouk (2014)
idea is an instance of Riemannian manifold HMC (Girolami and Calderhead, 2011).

The transformed transition kernel enables arbitrary bijective transformations
of arbitrary transition kernels, e.g., one could use bijectors
\code{tfb_affine}, \code{tfb_real_nvp}, etc.
with transition kernels \code{mcmc_hamiltonian_monte_carlo}, \code{mcmc_random_walk_metropolis}, etc.
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1412.5492}{Matthew Parno and Youssef Marzouk. Transport map accelerated Markov chain Monte Carlo. \emph{arXiv preprint arXiv:1412.5492}, 2014.}
\item \href{http://people.ee.duke.edu/~lcarin/Girolami2011.pdf}{Mark Girolami and Ben Calderhead. Riemann manifold langevin and hamiltonian monte carlo methods. In \emph{Journal of the Royal Statistical Society}, 2011.}
}
}

\seealso{
Other mcmc_kernels: 
\code{\link{mcmc_dual_averaging_step_size_adaptation}()},
\code{\link{mcmc_hamiltonian_monte_carlo}()},
\code{\link{mcmc_metropolis_adjusted_langevin_algorithm}()},
\code{\link{mcmc_metropolis_hastings}()},
\code{\link{mcmc_no_u_turn_sampler}()},
\code{\link{mcmc_random_walk_metropolis}()},
\code{\link{mcmc_replica_exchange_mc}()},
\code{\link{mcmc_simple_step_size_adaptation}()},
\code{\link{mcmc_slice_sampler}()},
\code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}()},
\code{\link{mcmc_uncalibrated_langevin}()},
\code{\link{mcmc_uncalibrated_random_walk}()}
}
\concept{mcmc_kernels}
