% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{modify.tfm}
\alias{modify.tfm}
\alias{modify}
\alias{modify.um}
\title{Modifying a TF or an ARIMA model}
\usage{
\method{modify}{tfm}(mdl, ...)

modify(mdl, ...)

\method{modify}{um}(
  mdl,
  ar = NULL,
  i = NULL,
  ma = NULL,
  mu = NULL,
  sig2 = NULL,
  bc = NULL,
  fit = TRUE,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{um} or \code{tfm}.}

\item{...}{additional arguments.}

\item{ar}{list of stationary AR lag polynomials.}

\item{i}{list of nonstationary AR (I) polynomials.}

\item{ma}{list of MA polynomials.}

\item{mu}{mean of the stationary time series.}

\item{sig2}{variance of the error.}

\item{bc}{logical. If TRUE logs are taken.}

\item{fit}{logical. If TRUE, model is fitted.}
}
\value{
An object of class \code{um} or \code{um}.
}
\description{
\code{modify} modifies an object of class \code{um} or \code{tfm} 
by adding and/or removing lag polynomials.
}
\examples{
um1 <- um(ar = "(1 - 0.8B)")
um2 <- modify(um1, ar = list(0, "(1 - 0.9B)"), ma = "(1 - 0.5B)")
}
