% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-proportion.R
\name{proportion-expectations}
\alias{proportion-expectations}
\alias{expect_prop_lte}
\alias{expect_prop_gte}
\alias{expect_prop_nmiss}
\alias{expect_prop_values}
\title{Expectations: proportions}
\usage{
expect_prop_lte(
  var,
  func,
  prop,
  flt = TRUE,
  data = get_testdata(),
  args = list(),
  func_desc = NULL
)

expect_prop_gte(
  var,
  func,
  prop,
  flt = TRUE,
  data = get_testdata(),
  args = list(),
  func_desc = NULL
)

expect_prop_nmiss(
  var,
  prop,
  miss = getOption("testdat.miss"),
  flt = TRUE,
  data = get_testdata()
)

expect_prop_values(var, prop, ..., flt = TRUE, data = get_testdata())
}
\arguments{
\item{var}{An unquoted column name to test.}

\item{func}{A function to use for testing that takes a vector as the first
argument and returns a logical vector of the same length showing whether an
element passed or failed.}

\item{prop}{The proportion of the data frame expected to satisfy the
condition.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}

\item{args}{A named list of arguments to pass to \code{func}.}

\item{func_desc}{A human friendly description of \code{func} to use in the
expectation failure message.}

\item{miss}{A vector of values to be treated as missing. The
\link[=testdat]{testdat.miss} option is used by default.}

\item{...}{Vectors of valid values.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
These test the proportion of data in a data frame satisfying some condition.
The generic functions, \code{expect_prop_lte()} and \code{expect_prop_gte()}, can be
used with any arbitrary function. The \verb{chk_*()} functions, like
\code{chk_values()}, are useful in this regard.
}
\details{
Given the use of quasi-quotation within these functions, to make a new
functions using one of the generics such as \code{expect_prop_gte()} one must
defuse the \code{var} argument using the embracing operator \code{{{ }}}. See the
examples sections for an example.
}
\examples{
sales <- data.frame(
  sale_id = 1:5,
  date = c("20200101", "20200101", "20200102", "20200103", "2020003"),
  sale_price = c(10, 20, 30, 40, -1),
  book_title = c(
    "Phenomenology of Spirit",
    NA,
    "Critique of Practical Reason",
    "Spirit of Trust",
    "Empiricism and the Philosophy of Mind"
  ),
  stringsAsFactors = FALSE
)

# Create a custom expectation
expect_prop_length <- function(var, len, prop, data) {
  expect_prop_gte(
    var = {{var}}, # Notice the use of the embracing operator
    func = chk_max_length,
    prop = prop,
    data = data,
    args = list(len = len),
    func_desc = "length_check"
  )
}

# Use it to check that dates are mostly <= 8 char wide
expect_prop_length(date, 8, 0.9, sales)

# Check price values mostly between 0 and 100
try(expect_prop_values(sale_price, 0.9, 1:100, data = sales))

}
\seealso{
\verb{chk_*()} functions such as \code{\link[=chk-values]{chk_values()}}

Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{expect_depends}()},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
