% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tci_algorithms.R
\name{tci_effect}
\alias{tci_effect}
\title{Effect-site TCI algorithm with plasma targeting within small range of target}
\usage{
tci_effect(Ct, pkmod, dtm = 1/6, cptol = 0.2, cetol = 0.05, ...)
}
\arguments{
\item{Ct}{Numeric vector of target effect-site concentrations.}

\item{pkmod}{PK model}

\item{dtm}{TCI update frequency. Defaults to 1/6, corresponding to 10-second
intervals if model parameters are in terms of minutes.}

\item{cptol}{Percentage of plasma concentration required to be within to switch
to plasma targeting.}

\item{cetol}{Percentage of effect-site concentration required to be within to switch
to plasma targeting.}

\item{...}{Arguments passed on to 'tci_plasma' and 'tci_effect_only' functions, including
to update.pkmod.}
}
\value{
Numeric value
}
\description{
Modified effect-site TCI algorithm that switches to plasma-targeting when the
plasma concentration is within 20\%
of the target and the effect-site concentration is within 0.5\% of the target.
The modification decreases computation time and prevents oscillatory behavior
in the effect-site concentrations.
}
\examples{
my_mod <- pkmod(pars_pk = c(v1 = 8.995, v2 = 17.297, v3 = 120.963, cl = 1.382,
q2 = 0.919, q3 = 0.609, ke0 = 1.289))
tci_effect(Ct = 2, pkmod = my_mod)
# update parameters
tci_effect(Ct = 2, pkmod = my_mod, pars_pk = c(v1 = 12, cl = 2))
}
