% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_olc}
\alias{simulate_olc}
\title{Simulate open-loop control using TCI}
\usage{
simulate_olc(
  pkmod_prior,
  pkmod_true,
  target_vals,
  target_tms,
  obs_tms,
  type = c("effect", "plasma"),
  custom_alg = NULL,
  resp_bounds = NULL,
  seed = NULL
)
}
\arguments{
\item{pkmod_prior}{`pkmod` object describing a PK/PK-PD model that is used to calculate
TCI infusion rates and is updated as data are simulated and incorporated. Must have an
associated Omega matrix.}

\item{pkmod_true}{`pkmod` object describing the patient's "true" response. This model
will be used to simulate observations.}

\item{target_vals}{A vector of numeric values indicating PK or PD targets for TCI algorithm.}

\item{target_tms}{A vector of numeric values indicating times at which the TCI algorithm should
begin targeting each value.}

\item{obs_tms}{Times at which data values should be simulated from `pkmod_true`.}

\item{type}{Type of TCI algorithm to be used. Options are "plasma" and "effect".
Defaults to "effect". Will be overwritten if `custom_alg` is non-null.}

\item{custom_alg}{Custom TCI algorithm to overwrite default plasma- or effect-site targeting.}

\item{resp_bounds}{Optional vector of two values indicating minimum and maximum values possible for the response.}

\item{seed}{An integer used to initialize the random number generator.}
}
\description{
Simulate open-loop control using TCI for `pkmod` or `poppkmod` objects.
Infusion rates are calculated using `pkmod_prior` to reach `target_vals` at
`target_tms`. Data values are simulated using `pkmod_true` at `obs_tms`.
`pkmod_prior` and `pkmod_true` do not need to have the same structure, but
are required to have the same number of IDs (i.e., N) if `poppkmod` objects
are used.
}
\examples{
data <- data.frame(ID = 1:5, AGE = seq(20,60,by=10), TBW = seq(60,80,by=5),
HGT = seq(150,190,by=10), MALE = c(TRUE,TRUE,FALSE,FALSE,FALSE))
pkmod_prior <- poppkmod(data, drug = "ppf", model = "eleveld")
pkmod_true  <- poppkmod(data, drug = "ppf", model = "eleveld", sample = TRUE)
obs_tms <- seq(1/6,10,1/6)
target_vals = c(75,60,50,50)
target_tms = c(0,3,6,10)
sim <- simulate_olc(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms)
len <- 500
tms <- seq(0,10,length.out = len)
resp <- data.frame(rbind(predict(pkmod_true, sim$inf, tms),
predict(pkmod_prior, sim$inf, tms)))
resp$type = c(rep("true",len*5),rep("prior",len*5))
library(ggplot2)
ggplot(resp) + geom_line(aes(x = time, y = pdresp, color = factor(id))) + facet_wrap(~type) +
  labs(x = "Hours", y = "Bispectral Index") + theme_bw() +
  geom_step(data = data.frame(time = target_tms, value = target_vals),
  aes(x = time, y = value), inherit.aes = FALSE)
}
