% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{init_pkmod}
\alias{init_pkmod}
\title{Create an object with class "pkmod"}
\usage{
init_pkmod(
  pars_pk = NULL,
  init = NULL,
  pkfn = NULL,
  pars_pd = NULL,
  pdfn = NULL,
  pdinv = NULL,
  pcmpt = NULL,
  ecmpt = NULL,
  sigma_add = NULL,
  sigma_mult = NULL,
  log_response = NULL,
  Omega = NULL
)
}
\arguments{
\item{pars_pk}{Vector or matrix of named PK parameters. If not specified, the pkmod function will be
inferred from the parameter names. Print `list_parnms()` for acceptable parameter names.}

\item{init}{Vector of initial concentrations. Will default to values of zero in all compartments if not specified.}

\item{pkfn}{PK model function. Functions provided in `tci` include `pkmod1cpt`, `pkmod2cpt`, `pkmod3cpt`, and `pkmod3cptm`.
User-defined functions should be specified here.}

\item{pars_pd}{PD model parameters if a PD model is specified}

\item{pdfn}{PD model function}

\item{pdinv}{Inverse PD model function for use in TCI algorithms}

\item{pcmpt}{Index of plasma compartment. Defaults to first compartment if not specified.}

\item{ecmpt}{Index of effect-site compartment if a PD model is specified. Will default to last compartment if unspecified.}

\item{sigma_add}{Standard deviation of additive residual error}

\item{sigma_mult}{Standard deviation of multiplicative residual error}

\item{log_response}{Logical value indicating if the response should be logged prior to adding error.}

\item{Omega}{Optional matrix of random effect parameters. Column names should correspond to names of
pars_pk, pars_pd, and sigma_add or sigma_mult.}
}
\value{
A list with class pkmod for which print, plot, predict, and simulate methods exist.
}
\description{
Create an object with class "pkmod"
}
\examples{
# create a pkmod object for a one compartment model with plasma targeting
init_pkmod()
}
