% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkpd_assist.R
\name{infer_pkfn}
\alias{infer_pkfn}
\title{Identify pkfn from parameter names}
\usage{
infer_pkfn(parnms)
}
\arguments{
\item{parnms}{Vector of parameter names.}
}
\value{
Returns one of the following functions: `pkmod1cpt`, `pkmod2cpt`, `pkmod3cpt`,
or `pkmod3cptm` based on the parameter names entered.
}
\description{
Identify structural PK model function (i.e., `pkfn`) from parameter names.
Models available are 1-, 2-, and 3-compartment mammillary models, or 3-compartment with
an effect site, corresponding to functions `pkmod1cpt`, `pkmod2cpt`, `pkmod3cpt`, and
`pkmod3cptm`, respectively.
}
\examples{
# 1-compartment
infer_pkfn(c("CL","V"))
infer_pkfn(c("Cl","v1"))
# 2-compartment
infer_pkfn(c("CL","v","v2","q"))
# 3-compartment
infer_pkfn(c("CL","v","v2","q","Q2","V3"))
# 3-compartment with effect-site
infer_pkfn(c("CL","v","v2","q","Q2","V3","ke0"))
}
