% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRPCAMS_methods.R
\name{plot.msPCA}
\alias{plot.msPCA}
\title{Plot Method for msPCA Objects}
\usage{
\method{plot}{msPCA}(x, type = c("loadings"), ...)
}
\arguments{
\item{x}{An object of class \code{"msPCA"}.}

\item{type}{Type of plot to produce. One of: \code{"loadings"} (default), \code{"screeplot"}, \code{"scores"},
\code{"biplot"}, or \code{"score_distances"}.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A ggplot2 object or list of plots, depending on the type.
}
\description{
Generic plotting interface for objects of class \code{"msPCA"}. Depending on the \code{type} argument,
this function visualizes loadings, scores, screeplots, biplots, or score distances.
}
\details{
If \code{type = "loadings"} a heatmap of loadings across groups is displayed. Optional input arguments are:
\tabular{ll}{
   \code{k} \tab Integer. The k-th principal component will be plotted.  \cr
   \code{text} \tab Boolean, whether the loading values should also be displayed as text. Default \code{FALSE}. \cr
   \code{size} \tab Numeric. Text size when \code{text} is \code{TRUE}. \cr
   \code{gnames} \tab Character vector. Names for groups (shown in plots). \cr
   \code{cnames} \tab Character vector. Names for variables (shown in plots). \cr
   \code{textrotate} \tab Rotation angle of text in the heatmap.\cr
   \code{tolerance} \tab Numeric, default 1e-04. Specifies the band of white color values around zero. \cr
}

If \code{type = "screeplot"} boxplots of the explained variance per component and cumulative variance per group are plotted. Optional input arguments are:
\tabular{ll}{
   \code{text} \tab Boolean, whether the loading values should also be displayed as text. Default \code{TRUE}. \cr
   \code{size} \tab Numeric. Text size when \code{text} is \code{TRUE}. \cr
   \code{gnames} \tab Character vector. Names for groups (shown in plots). \cr
   \code{cutoff} \tab Scalar with default value 0.8. The cumulative percentage cutoff value for the overall explained variance. \cr
   \code{textrotate} \tab Rotation angle of text in the heatmap.\cr
}

If \code{type = "biplot"} the loadings are visualized in the first and second component over all groups. Optional input arguments are:
\tabular{ll}{
   \code{color} \tab Character. Either \code{"variable"} (default) when the color should be connected to the variables or \code{"groups"} if the color should correspond to the groups. \cr
   \code{size} \tab Numeric. Text size when \code{text} is \code{TRUE}. \cr
   \code{alpha} \tab Alpha value for the loading points, default is \code{0.7} .\cr
}

If \code{type = "scores"} a histogram of the k-th scores per group are shown. Optional input arguments are:
\tabular{ll}{
   \code{k} \tab Integer. The k-th principal component will be plotted. Default value is one.  \cr
   \code{ssMRCD} An object of class \code{ssMRCD} including list elements \code{MRCDcov, MRCDmu, mX}.  Alternatively, \code{X, groups, mu, Sigma} can be provided..
   \code{X, groups, mu, Sigma} The original data matrix, a vector of groups as for \code{ssMRCD}, a list of location vectors and a list of covariance matrices. \cr
  Alternatively, a \code{ssMRCD} object can be given. \cr
   \code{alpha} \tab Alpha value for histogramm, default is \code{0.7} .\cr
}

If \code{type = "score_distances"} a distance-distance plot of score and orthogonal distances is shown for each group. of the k-th scores per group are shown. Optional input arguments are:
\tabular{ll}{
   \code{k} \tab Integer. Using the first k PCs for the distances. Default is the number of provided PCs.
   \code{ssMRCD} An object of class \code{ssMRCD} including list elements \code{MRCDcov, MRCDmu, mX}.  Alternatively, \code{X, groups, mu, Sigma} can be provided..
   \code{X, groups, mu, Sigma} The original data matrix, a vector of groups as for \code{ssMRCD}, a list of location vectors and a list of covariance matrices. \cr
  Alternatively, a \code{ssMRCD} object can be given. \cr
   \code{shape} \tab Point shape. \cr
   \code{size} \tab Numeric. Point size. \cr
   \code{alpha} \tab Alpha value for the points, default is \code{0.7} .\cr
}
}
\examples{
# set seed
set.seed(236)

# create data and setup
data = matrix(rnorm(2000), ncol = 4)
groups = sample(1:10, 500, replace = TRUE)
W = time_weights(N = 10, c(3,2,1))

# calculate covariances
covs = ssMRCD(data, groups = groups, weights = W, lambda = 0.3)

# calculate sparse PCA
pca = msPCA(eta = 1.3, gamma = 0.7, COVS = covs$MRCDcov)

# plot screeplot
plot(x = pca, type = "screeplot")

# align and plot loadings
pca$PC = align(PC = pca$PC, type = "mean")
plot(x = pca, type = "loadings", k = 1)
pca$PC = align(PC = pca$PC, type = "maxvar")
plot(x = pca, type = "loadings", k = 1)
pca$PC = align(PC = pca$PC, type = "largest")
plot(x = pca, type = "loadings", k = 1)

# plot different PCA plots
plot(x = pca, type = "score_distances", k = 2,
groups = groups, X = data, mu = covs$MRCDmu, Sigma = covs$MRCDcov)
plot(x = pca, type = "biplot", color = "variable")
plot(x = pca, type = "scores", ssMRCD = covs, k = 1)
plot(x = pca, type = "loadings", k = 1)
}
\seealso{
\code{\link[ssMRCD]{msPCA}}, \code{\link[ssMRCD]{align}},
\code{\link[ssMRCD]{screeplot.msPCA}}, , \code{\link[ssMRCD]{biplot.msPCA}},
\code{\link[ssMRCD]{scores}},
}
