% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sobolev.R
\name{Sobolev}
\alias{Sobolev}
\alias{d_p_k}
\alias{weights_dfs_Sobolev}
\alias{d_Sobolev}
\alias{p_Sobolev}
\alias{q_Sobolev}
\title{Asymptotic distributions of Sobolev statistics of spherical uniformity}
\usage{
d_p_k(p, k, log = FALSE)

weights_dfs_Sobolev(p, K_max = 1000, thre = 0.001, type,
  Poisson_rho = 0.5, Pycke_q = 0.5, Riesz_s = 1, Rothman_t = 1/3,
  Sobolev_vk2 = c(0, 0, 1), Softmax_kappa = 1, Stein_cf = FALSE,
  Stereo_a = 0, log = FALSE, verbose = TRUE, Gauss = TRUE, N = 320,
  tol = 1e-06, force_positive = TRUE, x_tail = NULL)

d_Sobolev(x, p, type, method = c("I", "SW", "HBE")[1], K_max = 1000,
  thre = 0.001, Rothman_t = 1/3, Pycke_q = 0.5, Riesz_s = 1,
  Poisson_rho = 0.5, Softmax_kappa = 1, Stereo_a = 0,
  Sobolev_vk2 = c(0, 0, 1), ncps = 0, verbose = TRUE, N = 320,
  x_tail = NULL, ...)

p_Sobolev(x, p, type, method = c("I", "SW", "HBE", "MC")[1], K_max = 1000,
  thre = 0.001, Rothman_t = 1/3, Pycke_q = 0.5, Riesz_s = 1,
  Poisson_rho = 0.5, Softmax_kappa = 1, Stereo_a = 0,
  Sobolev_vk2 = c(0, 0, 1), ncps = 0, verbose = TRUE, N = 320,
  x_tail = NULL, ...)

q_Sobolev(u, p, type, method = c("I", "SW", "HBE", "MC")[1], K_max = 1000,
  thre = 0.001, Rothman_t = 1/3, Pycke_q = 0.5, Riesz_s = 1,
  Poisson_rho = 0.5, Softmax_kappa = 1, Stereo_a = 0,
  Sobolev_vk2 = c(0, 0, 1), ncps = 0, verbose = TRUE, N = 320,
  x_tail = NULL, ...)
}
\arguments{
\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}

\item{k}{sequence of integer indexes.}

\item{log}{compute the logarithm of \eqn{d_{p,k}}? Defaults to
\code{FALSE}.}

\item{K_max}{integer giving the truncation of the series that compute the
asymptotic p-value of a Sobolev test. Defaults to \code{1e3}.}

\item{thre}{error threshold for the tail probability given by the
the first terms of the truncated series of a Sobolev test. Defaults to
\code{1e-3}.}

\item{type}{name of the Sobolev statistic, using the naming from
\code{\link{avail_cir_tests}} and \code{\link{avail_sph_tests}}.}

\item{Poisson_rho}{\eqn{\rho} parameter for the Poisson test, a real in
\eqn{[0, 1)}. Defaults to \code{0.5}.}

\item{Pycke_q}{\eqn{q} parameter for the Pycke "\eqn{q}-test", a real in
\eqn{(0, 1)}. Defaults to \code{1 / 2}.}

\item{Riesz_s}{\eqn{s} parameter for the \eqn{s}-Riesz test, a real in
\eqn{(0, 2)}. Defaults to \code{1}.}

\item{Rothman_t}{\eqn{t} parameter for the Rothman test, a real in
\eqn{(0, 1)}. Defaults to \code{1 / 3}.}

\item{Sobolev_vk2}{weights for the finite Sobolev test. A non-negative
vector or matrix. Defaults to \code{c(0, 0, 1)}.}

\item{Softmax_kappa}{\eqn{\kappa} parameter for the Softmax test, a
non-negative real. Defaults to \code{1}.}

\item{Stein_cf}{logical indicating whether to use the characteristic
function in the Stein test. Defaults to \code{FALSE} (moment generating
function).}

\item{Stereo_a}{\eqn{a} parameter for the Stereo test, a real in
\eqn{[-1, 1]}. Defaults to \code{0}.}

\item{verbose}{output information about the truncation? Defaults to
\code{TRUE}.}

\item{Gauss}{use a Gauss--Legendre quadrature rule of \code{N} nodes
in the computation of the Gegenbauer coefficients? Otherwise, call
\code{\link{integrate}}. Defaults to \code{TRUE}.}

\item{N}{number of points used in the \link[=Gauss_Legen_nodes]{
Gauss--Legendre quadrature} for computing the Gegenbauer coefficients.
Defaults to \code{320}.}

\item{tol}{tolerance passed to \code{\link{integrate}}'s \code{rel.tol} and
\code{abs.tol} if \code{Gauss = FALSE}. Defaults to \code{1e-6}.}

\item{force_positive}{set negative weights to zero? Defaults to \code{TRUE}.}

\item{x_tail}{scalar evaluation point for determining the upper tail
probability. If \code{NULL}, set to the \code{0.90} quantile of the whole
series, computed by the \code{"HBE"} approximation.}

\item{x}{vector of quantiles.}

\item{method}{method for approximating the density, distribution, or
quantile function of the weighted sum of chi squared random variables. Must
be \code{"I"} (Imhof), \code{"SW"} (Satterthwaite--Welch), \code{"HBE"}
(Hall--Buckley--Eagleson), or \code{"MC"} (Monte Carlo; only for distribution
or quantile functions). Defaults to \code{"I"}.}

\item{ncps}{non-centrality parameters. Either \code{0} (default) or a
vector with the same length as \code{weights}.}

\item{...}{further parameters passed to \code{*_\link{wschisq}}.}

\item{u}{vector of probabilities.}
}
\value{
\itemize{
  \item \code{d_p_k}: a vector of size \code{length(k)} with the
  evaluation of \eqn{d_{p,k}}.
  \item \code{weights_dfs_Sobolev}: a list with entries \code{weights} and
  \code{dfs}, automatically truncated according to \code{K_max} and
  \code{thre} (see details).
  \item \code{d_Sobolev}: density function evaluated at \code{x}, a vector.
  \item \code{p_Sobolev}: distribution function evaluated at \code{x},
  a vector.
  \item \code{q_Sobolev}: quantile function evaluated at \code{u}, a vector.
}
}
\description{
Approximated density, distribution, and quantile functions for
the asymptotic null distributions of Sobolev statistics of uniformity
on \eqn{S^{p-1}:=\{{\bf x}\in R^p:||{\bf x}||=1\}}{S^{p-1}:=
\{x\in R^p:||x||=1\}}. These asymptotic distributions are infinite
weighted sums of (central) chi squared random variables:
\deqn{\sum_{k = 1}^\infty v_k^2 \chi^2_{d_{p, k}},}
where
\deqn{d_{p, k} := {{p + k - 3}\choose{p - 2}} + {{p + k - 2}\choose{p - 2}}}
is the dimension of the space of eigenfunctions of the Laplacian on
\eqn{S^{p-1}}, \eqn{p\ge 2}, associated to the \eqn{k}-th
eigenvalue, \eqn{k\ge 1}.
}
\details{
The truncation of \eqn{\sum_{k = 1}^\infty v_k^2 \chi^2_{d_{p, k}}} is
done to the first \code{K_max} terms and then up to the index such that
the first terms explain the tail probability at the \code{x_tail} with
an absolute error smaller than \code{thre} (see details in
\code{\link{cutoff_wschisq}}). This automatic truncation takes place when
calling \code{*_Sobolev}. Setting \code{thre = 0} truncates to \code{K_max}
terms exactly. If the series only contains odd or even non-zero terms, then
only \code{K_max / 2} addends are \emph{effectively} taken into account
in the first truncation.
}
\examples{
# Circular-specific statistics
curve(p_Sobolev(x = x, p = 2, type = "Watson", method = "HBE"),
      n = 2e2, ylab = "Distribution", main = "Watson")
curve(p_Sobolev(x = x, p = 2, type = "Rothman", method = "HBE"),
      n = 2e2, ylab = "Distribution", main = "Rothman")
curve(p_Sobolev(x = x, p = 2, type = "Pycke_q", method = "HBE"), to = 10,
      n = 2e2, ylab = "Distribution", main = "Pycke_q")
curve(p_Sobolev(x = x, p = 2, type = "Hermans_Rasson", method = "HBE"),
      to = 10, n = 2e2, ylab = "Distribution", main = "Hermans_Rasson")

# Statistics for arbitrary dimensions
test_statistic <- function(type, to = 1, pmax = 5, M = 1e3, ...) {

  col <- viridisLite::viridis(pmax - 1)
  curve(p_Sobolev(x = x, p = 2, type = type, method = "MC", M = M,
                  ...), to = to, n = 2e2, col = col[pmax - 1],
                  ylab = "Distribution", main = type, ylim = c(0, 1))
  for (p in 3:pmax) {
    curve(p_Sobolev(x = x, p = p, type = type, method = "MC", M = M,
                    ...), add = TRUE, n = 2e2, col = col[pmax - p + 1])
  }
  legend("bottomright", legend = paste("p =", 2:pmax), col = rev(col),
         lwd = 2)

}

# Ajne
test_statistic(type = "Ajne")
\donttest{
# Gine_Gn
test_statistic(type = "Gine_Gn", to = 1.5)

# Gine_Fn
test_statistic(type = "Gine_Fn", to = 2)

# Bakshaev
test_statistic(type = "Bakshaev", to = 3)

# Riesz
test_statistic(type = "Riesz", Riesz_s = 0.5, to = 3)

# PCvM
test_statistic(type = "PCvM", to = 0.6)

# PAD
test_statistic(type = "PAD", to = 3)

# PRt
test_statistic(type = "PRt", Rothman_t = 0.5)

# Quantiles
p <- c(2, 3, 4, 11)
t(sapply(p, function(p) q_Sobolev(u = c(0.10, 0.05, 0.01), p = p,
                                  type = "PCvM")))
t(sapply(p, function(p) q_Sobolev(u = c(0.10, 0.05, 0.01), p = p,
                                  type = "PAD")))
t(sapply(p, function(p) q_Sobolev(u = c(0.10, 0.05, 0.01), p = p,
                                  type = "PRt")))

# Series truncation for thre = 1e-5
sapply(p, function(p) length(weights_dfs_Sobolev(p = p, type = "PCvM")$dfs))
sapply(p, function(p) length(weights_dfs_Sobolev(p = p, type = "PRt")$dfs))
sapply(p, function(p) length(weights_dfs_Sobolev(p = p, type = "PAD")$dfs))
}
}
\author{
Eduardo García-Portugués and Paula Navarro-Esteban.
}
