% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concentration.R
\name{concentration}
\alias{concentration}
\title{Concentration calculation}
\usage{
concentration(
  sub,
  full,
  value,
  lon_sub = lon,
  lat_sub = lat,
  lon_full = lon,
  lat_full = lat,
  radius = 200,
  display_progress = TRUE
)
}
\arguments{
\item{sub}{data.frame of target points to calculate concentration risk for,
including at least columns for longitude and latitude.}

\item{full}{data.frame containing reference points, where the function finds
locations within a radius from the target points. Should include at least
columns for longitude, latitude, and the value of interest to summarize.}

\item{value}{column name with value of interest to summarize in \code{full}.}

\item{lon_sub}{column name in \code{sub} for longitude
(default is \code{lon}).}

\item{lat_sub}{column name in \code{sub} for latitude
(default is \code{lat}).}

\item{lon_full}{column name in \code{full} for longitude in \code{full}
(default is \code{lon}).}

\item{lat_full}{column name in \code{full} for latitude in \code{full}
(default is \code{lat}).}

\item{radius}{numeric. Radius of the circle in meters (default is 200).}

\item{display_progress}{boolean indicating whether to show progress bar
(TRUE/FALSE). Defaults to TRUE.}
}
\value{
A data.frame equal to \code{sub} including an additional
column \code{concentration}.
}
\description{
Calculates the concentration, which is the sum of all
observations within a circle of a certain radius.
}
\examples{
df <- data.frame(location = c("p1", "p2"), lon = c(6.561561, 6.561398),
 lat = c(53.21369, 53.21326))
concentration(df, Groningen, value = amount, radius = 100)

}
\author{
Martin Haringa
}
