% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatioSDRMS.R
\name{RatioSDRMS}
\alias{RatioSDRMS}
\title{Compute the ratio between the ensemble spread and RMSE}
\usage{
RatioSDRMS(
  exp,
  obs,
  dat_dim = NULL,
  memb_dim = "member",
  time_dim = "sdate",
  pval = TRUE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numeric array of experimental data with at least two 
dimensions 'memb_dim' and 'time_dim'.}

\item{obs}{A named numeric array of observational data with at least two 
dimensions 'memb_dim' and 'time_dim'. It should have the same dimensions as
parameter 'exp' except along 'dat_dim' and 'memb_dim'.}

\item{dat_dim}{A character string indicating the name of dataset (nobs/nexp) 
dimension. The default value is NULL (no dataset).}

\item{memb_dim}{A character string indicating the name of the member 
dimension. It must be one dimension in 'exp' and 'obs'. The default value 
is 'member'.}

\item{time_dim}{A character string indicating the name of dimension along
which the ratio is computed. The default value is 'sdate'.}

\item{pval}{A logical value indicating whether to compute or not the p-value 
of the test Ho : SD/RMSE = 1 or not. The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list of two arrays with dimensions c(nexp, nobs, the rest of 
 dimensions of 'exp' and 'obs' except memb_dim and time_dim), which nexp is
 the length of dat_dim of 'exp' and nobs is the length of dat_dim of 'obs'. 
 If dat_dim is NULL, nexp and nobs are omitted. \cr
\item{$ratio}{
 The ratio of the ensemble spread and RMSE.
}
\item{$p_val}{
 The p-value of the one-sided Fisher's test with Ho: SD/RMSE = 1. Only present
 if \code{pval = TRUE}.
}
}
\description{
Compute the ratio between the standard deviation of the members around the 
ensemble mean in experimental data and the RMSE between the ensemble mean of 
experimental and observational data. The p-value is provided by a one-sided 
Fisher's test.
}
\examples{
# Load sample data as in Load() example:
example(LoadSampleData)
rsdrms <- RatioSDRMS(sampleData$mod, sampleData$obs, dat_dim = 'dataset')
# Reorder the data in order to plot it with PlotVsLTime
rsdrms_plot <- array(dim = c(dim(rsdrms$ratio)[1:2], 4, dim(rsdrms$ratio)[3]))
rsdrms_plot[, , 2, ] <- rsdrms$ratio
rsdrms_plot[, , 4, ] <- rsdrms$p.val
  \donttest{
PlotVsLTime(rsdrms_plot, toptitle = "Ratio ensemble spread / RMSE", ytitle = "", 
            monini = 11, limits = c(-1, 1.3), listexp = c('CMIP5 IC3'), 
            listobs = c('ERSST'), biglab = FALSE, siglev = TRUE) 
 }

}
