% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy-entity.R
\name{Entity}
\alias{Entity}
\alias{get_entity_data}
\alias{get_entity_value}
\alias{put_entity_data}
\alias{put_entity_value}
\title{Load and store Entity NBT data}
\usage{
get_entity_data(x, z, dimension, db = default_db())

get_entity_value(x, z, dimension, db = default_db())

put_entity_data(values, x, z, dimension, db = default_db())

put_entity_value(value, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{values}{A (named) list of list of NBT objects.}

\item{value}{A list of NBT objects.}
}
\value{
\code{get_entity_value()} returns a list of NBT objects.
\code{get_entity_data()} returns a named list of lists of NBT objects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Entity data (tag 50) holds a list of NBT values for mobs and other entities
in the game. After 1.18.30, entity data was migrated to a new actor digest
format and no longer saved with chunk data.
\itemize{
\item \code{get_entity_value()} and \code{get_entity_data()} load Entity
data from \code{db}. \code{get_entity_value()} loads data for a single chunk,
and \code{get_entity_data()} loads data for multiple chunks.
\item \code{put_entity_value()} and \code{put_entity_data()} store Entity
data for one or multiple chunks into \code{db}.
}
}
\keyword{internal}
