% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDI.R
\name{SDI}
\alias{SDI}
\title{Computes graph or vertex level Spatial Dispersion Index(ces).}
\usage{
SDI(
  flows,
  nodes = NULL,
  distance.calculation = NULL,
  level = "vertex",
  weight.use = "weighted",
  directionality = "undirected",
  variant = NULL,
  alpha = NULL
)
}
\arguments{
\item{flows}{A data frame or an igraph object}

\item{nodes}{if flows are data frame, nodes must be supplied as a data frame. If flows are igraph object then not required}

\item{distance.calculation}{optional method for distance calculation. 'Haversine' or 'Euclidean'. If not provided and edge distances are not available, distances are calculated by the SDI function.}

\item{level}{The level to calculate the SDI. 'network' or 'vertex'}

\item{weight.use}{'weighted', 'unweighted', or 'generalized'}

\item{directionality}{'undirected', 'in', 'out', or 'all'}

\item{variant}{Optional. Instead of specifying the level, directionality, and weight separately, the user can just supply a short-code of initial letters of each in that order to this argument, e.g. "vuw" for vertex level, undirected and weighted SDI. If it is a vector each value is treated separetely and multiple indices are computed.}

\item{alpha}{Optional parameter used for generalized SDI calculations.}
}
\value{
An igraph object with SDI attributes added. The class of the object includes 'SDI'.
}
\description{
If 'flows' is an igraph object then one can avoid supplying the nodes parameter.
Alternatively one can supply flows as a data frame and nodes as another.
}
\details{
To have an SDI computed you can must provide level, weight.use, and directionality parameters.
Alternatively the 'variant' parameter can be specified which allows short-codes to indicate all of these three parameters.
For example a value of "vui" for variant means a **v**ertex level, **u**ndirected, and **i**nward directed SDI calculation.
See the description of these three parameters to figure out possible short codes in a similar fashion.

The function returns an igraph object. If a network level calculation is requested the object will have an
'SDI_...' attribute whose name follows the short codes explained above. If a vertex level calculation is requested
each vertex will have a similarly named attribute. For example the graph will have an 'SDI_nuw' attribute if variant is
"nuw" (network level, undirected, and weighted). If variant is "vwu" each vertex will have an "SDI_vwu" attribute containing
weighted undirected SDI for the vertex. If variant is a vector each value indicates a separate variant to be computed.
}
\examples{
SDI(TurkiyeMigration.flows, TurkiyeMigration.nodes, variant="vuw")

}
