% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autopal.R
\name{autopal}
\alias{autopal}
\title{Optimize color palette for color vision deficiency}
\usage{
autopal(
  n,
  colorspace = "pretty",
  cvd = c("protan", "deutan", "tritan"),
  target = 20
)
}
\arguments{
\item{n}{Number of colors to generate.}

\item{colorspace}{Either 1) a list of three named numeric vectors: \code{h}
(hue), \code{s} (saturation), and \code{l} (lightness), all of length 2
specifying a min and max value for the range. The values has to be in the
range -360 to 360 for \code{h}, and 0 to 1 for \code{s} and \code{l} 2), or
2) a \emph{character vector} specifying one of the predefined color spaces
(see below).}

\item{cvd}{Color vision deficiency adaptation to adapt the color palette to.}

\item{target}{Target color difference.}
}
\value{
A list of class \code{qualpal} with the following
  components.
  \item{HSL}{
    A matrix of the colors in the HSL color space.
  }
  \item{DIN99d}{
    A matrix of the colors in the DIN99d color space (after power
    transformations).
  }
  \item{RGB}{
    A matrix of the colors in the sRGB color space.} \item{hex}{A
    character vector of the colors in hex notation.} \item{de_DIN99d}{A
    distance matrix of color differences according to delta E DIN99d.
  }
  \item{min_de_DIN99d}{
    The smallest pairwise DIN99d color difference.
  }
}
\description{
This function adapts color palettes to color vision deficiency (CVD) by
optimizing the CVD severity to try reach a target color difference (DIN99d
\eqn{\delta E}) of the user's choosing. Basically, it will choose a color
palette that is as close as possible to the target \eqn{\delta E} by
tweaking the CVD severity option in \code{\link{qualpal}}.
}
\details{
The rationale for this function is that when there are few colors in a color
palette, there is no cost involved in adapting colors to CVD -- the colors
will still remain distinct. As more an more colors are added to the palette,
however, adapting the color palette to CVD will eventually lead to colors
that are too similar. This function gradually loosens the adaptation to CVDs
by lowering the severity of CVD to simulate to before picking colors (the
\code{cvd_severity} argument in \code{\link{qualpal}})
}
\examples{
pal <- autopal(3, cvd = "protan", target = 15)
plot(pal)

}
