% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictsr.R
\name{GetColumnDescriptions}
\alias{GetColumnDescriptions}
\title{Get a dataframe describing the columns in the PREDICTS database extract.}
\usage{
GetColumnDescriptions(...)
}
\arguments{
\item{...}{extra arguments passed to read.csv.}
}
\value{
The column descriptions in the format as a dataframe.
}
\description{
This function returns a dataframe containing the column descriptions for
the PREDICTS database extract.
}
\details{
The PREDICTS - Predicting Responses of Ecological Diversity In Changing
Terrestrial Systems - database contains a large number of columns, each
corresponding to a variable describing the site or the observation. This
function accesses the column descriptions for the PREDICTS database
extract.

The column descriptions are provided as a dataframe, with each row
corresponding to a column in the PREDICTS database extract.

There are two releases of the PREDICTS database, an initial release in 2016,
and an additional release in 2022. The user chooses whether to pull summary
data for the 2016 and/or 2022 release.

The data are provided under a CC NC (non-commercial) license, which means
that they cannot be used for commercial purposes. The 2016 release is
available under a CC BY-NC-SA 4.0 license, and the 2022 release is
available under a CC NC (any) license.
}
\examples{
\donttest{
  descriptions <- GetColumnDescriptions()
}

}
