//
//  linearExtension.h
//  POSet
//
//  Created by Alessandro Avellone on 11/04/2019.
//  Copyright © 2019 Alessandro Avellone. All rights reserved.
//

#ifndef linearExtension_hpp
#define linearExtension_hpp

#include <cstdint>
#include <vector>
#include <map>

class LinearExtension
{
private:
    std::vector<std::uint_fast64_t> by_position;
    std::map<std::uint_fast64_t, std::uint_fast64_t> by_element;  // key is poset element; value is position of the key element in the extension
public:
    LinearExtension(std::uint_fast64_t s) {
        this->by_position.resize(s);
    }
    
    // ***********************************************
    // ***********************************************
    // ***********************************************

    std::string to_string(char DELIMETER = ';') {
        std::string result = "";
        bool first = true;
        for (size_t k = 0; k < this->by_position.size(); ++k) {
            if (first) {
                result = "" + std::to_string(this->by_position[k]);
                first = false;
            }
            else {
                result += DELIMETER + std::to_string(this->by_position[k]);
            }
        }
        return result;
    }
    
    // ***********************************************
    // ***********************************************
    // ***********************************************

    std::uint_fast64_t size() const {
        return this->by_position.size();
    }
    
    // ***********************************************
    // ***********************************************
    // ***********************************************

    std::uint_fast64_t getVal(std::uint_fast64_t idx) const {
        return this->by_position.at(idx);
    }
    
    // ***********************************************
    // ***********************************************
    // ***********************************************

    std::uint_fast64_t getPos(std::uint_fast64_t e) const {
        return this->by_element.at(e);
    }
    
    // ***********************************************
    // ***********************************************
    // ***********************************************

    void set(std::uint_fast64_t idx, std::uint_fast64_t val) {
        this->by_position[idx] = val;
        this->by_element[val] = idx;
    }
    
    // ***********************************************
    // ***********************************************
    // ***********************************************
    
    LinearExtension& operator=(LinearExtension& m) {
        by_position = m.by_position;
        by_element = m.by_element;
        return *this;
    }

};


#endif /* linearExtension_hpp */
