% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_partition.R
\name{osrm_partition}
\alias{osrm_partition}
\title{Partition OSRM Graph for Multi-Level Dijkstra (MLD)}
\usage{
osrm_partition(
  input_osrm,
  threads = 8L,
  verbosity = c("INFO", "NONE", "ERROR", "WARNING", "DEBUG"),
  balance = 1.2,
  boundary = 0.25,
  optimizing_cuts = 10L,
  small_component_size = 1000L,
  max_cell_sizes = c(128, 4096, 65536, 2097152),
  quiet = FALSE,
  verbose = FALSE,
  spinner = TRUE,
  echo_cmd = FALSE
)
}
\arguments{
\item{input_osrm}{A string. Path to a \code{.osrm.timestamp} file, the base path to the \code{.osrm} files (without extension),
or a directory containing exactly one \code{.osrm.timestamp} file.}

\item{threads}{An integer. Number of threads to use; default \code{8} (osrm-partition's default).}

\item{verbosity}{A string. Log verbosity level passed to \code{-l/--verbosity}
(one of \verb{"NONE","ERROR","WARNING","INFO","DEBUG"}); default \code{"INFO"}.}

\item{balance}{A numeric. Balance for left and right side in single bisection; default \code{1.2}.}

\item{boundary}{A numeric. Percentage of embedded nodes to contract as sources and sinks; default \code{0.25}.}

\item{optimizing_cuts}{An integer. Number of cuts to use for optimizing a single bisection; default \code{10}.}

\item{small_component_size}{An integer. Size threshold for small components; default \code{1000}.}

\item{max_cell_sizes}{A numeric vector. Maximum cell sizes starting from level 1; default \code{c(128,4096,65536,2097152)}.}

\item{quiet}{A logical. Master switch that suppresses package messages and
process output when \code{TRUE}; default \code{FALSE}.}

\item{verbose}{A logical. When \code{TRUE} and \code{quiet = FALSE}, streams stdout and
stderr from the underlying \code{processx::run} calls.}

\item{spinner}{A logical. When \code{TRUE} and \code{quiet = FALSE}, shows a spinner
instead of live logs; default \code{TRUE}.}

\item{echo_cmd}{A logical. When \code{TRUE} and \code{quiet = FALSE}, prints each
command before running; default \code{FALSE}.}
}
\value{
An object of class \code{osrm_job} with the following elements:
\describe{
\item{osrm_job_artifact}{The path to the partitioned \code{.osrm.partition} file.}
\item{osrm_working_dir}{The directory containing all OSRM files.}
\item{logs}{The \code{processx::run} result object.}
}
}
\description{
Run the \code{osrm-partition} tool to partition an OSRM graph for the MLD pipeline.
After running, a companion \verb{<base>.osrm.partition} file must exist to confirm success.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # Prepare a small graph then partition it for the MLD pipeline
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)
  profile <- osrm_find_profile("car.lua")

  extract_job <- osrm_extract(
    input_osm = tmp_pbf,
    profile = profile,
    overwrite = TRUE,
    threads = 1L
  )

  partition_job <- osrm_partition(extract_job, threads = 1L, verbose = TRUE)
  partition_job$osrm_job_artifact

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}

}
