% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-attachment.R
\name{ns_get_attachment}
\alias{ns_get_attachment}
\title{Save Nettskjema attachments to file}
\usage{
ns_get_attachment(attachment_id, path = NULL)
}
\arguments{
\item{attachment_id}{integer. Unique ID of attachment, as found in the submission data.}

\item{path}{Character. Location to save the file.}
}
\value{
httr2-response. saves attachment to file.
}
\description{
The Nettskjema forms has an option
to upload attachments with forms.
These can be retrieved by this function.
Recommended workflow is to first call
\code{\link{ns_list_submission_attachments}},
and use the output of this to pass along
to the function. This function is called
by \code{\link{ns_get_form_attachments}},
but you can use it to define your own output
file names.
}
\examples{
\dontrun{
#submission_id <- c(22222, 1232, 21555)
#attach_dt <- ns_list_submission_attachments(submission_id)
#ns_save_attachment(path = attach_dt$path, output = attach_dt$standardized)
}
}
