% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{irps_nuclear_discourse}
\alias{irps_nuclear_discourse}
\title{Two-mode dynamic discourse network of Germany's nuclear energy phase-out (Haunss and Hollway 2023)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A dynamic, labelled, two-mode network of 337 speakers and 54 concepts and
#> 1164 claim ties from 2011-03-11 to 2011-06-30
#> 
#> -- Nodes
#> # A tibble: 391 x 10
#>   name         type  present politician govt  coalition office org   party power
#>   <chr>        <lgl> <lgl>   <lgl>      <lgl> <lgl>     <lgl>  <chr> <chr> <int>
#> 1 VfEW         FALSE TRUE    FALSE      FALSE NA        FALSE  VfEW  <NA>      0
#> 2 Angela Merk~ FALSE TRUE    TRUE       TRUE  TRUE      TRUE   CDU   31        2
#> 3 Sunday Times FALSE TRUE    FALSE      FALSE NA        FALSE  Sund~ <NA>      0
#> 4 SPD          FALSE TRUE    TRUE       FALSE FALSE     FALSE  SPD   32        1
#> 5 Norbert Röt~ FALSE TRUE    TRUE       TRUE  TRUE      TRUE   CDU   31        1
#> 6 Torsten Kra~ FALSE TRUE    FALSE      FALSE NA        FALSE  Die ~ <NA>      0
#> # i 385 more rows
#> 
#> -- Ties
#> # A tibble: 1,164 x 5
#>    from    to time       increment default
#>   <int> <int> <date>         <int> <lgl>  
#> 1     1   338 2011-03-11        -1 FALSE  
#> 2     2   339 2011-03-12         1 TRUE   
#> 3     3   340 2011-03-13        -1 FALSE  
#> 4     4   341 2011-03-13         1 TRUE   
#> 5     2   342 2011-03-13        -1 TRUE   
#> 6     5   343 2011-03-13         1 TRUE   
#> # i 1,158 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(irps_nuclear_discourse)
}
\description{
Following the 11 March 2011 Fukushima nuclear disaster in Japan,
there was a vigorous public debate in Germany about the future of nuclear energy.
This network captures the discourse established by 337 actors,
including individual politicians, experts, parties, and the media,
and their claims about nuclear energy and German nuclear energy policy.
These claims were with respect to 54 concepts coded,
and could be supportive or critical, and could also be repeated.
}
\references{
Haunss Sebastian, James Hollway. 2023.
"Multimodal mechanisms of political discourse dynamics and the case of Germany’s nuclear energy phase-out".
\emph{Network Science}, 11(2):205-223.
\doi{10.1017/nws.2022.31}
}
\keyword{datasets}
