% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_slot_usage.R
\name{get_slot_usage}
\alias{get_slot_usage}
\title{Get time slot usage of a schedule}
\usage{
get_slot_usage(schedule, orch_frequency, slot_interval = "hour")
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}

\item{orch_frequency}{of the orchestrator, a single string formatted like "1 day", "2 weeks", "hourly", etc.}

\item{slot_interval}{a time unit indicating the interval of time to consider between slots (e.g., 'hour', 'day')}
}
\value{
data.frame
}
\description{
Get the number of pipelines scheduled to run for each time slot at a particular
slot interval. Time slots are times that the orchestrator runs and the slot interval
determines the level of granularity to consider.
}
\details{
This function is particularly useful when you have multiple pipelines in a project
and you want to see what recurring time intervals may be available or underused
for new pipelines.

Note that this function is intended for use in an interactive session while developing
a maestro project. It is not intended for use in the orchestrator.

As an example, consider we have four pipelines running at various frequencies
and the orchestrator running every hour. Then let's say there's to be a new
pipeline that runs every day. One might ask 'what hour should I schedule this new
pipeline to run on?'. By using \code{get_slot_usage(schedule, orch_frequency = '1 hour', slot_interval = 'hour')}
on the existing schedule, you could identify for each hour how many pipelines
are already scheduled to run and choose the ones with the lowest usage.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  get_slot_usage(
    schedule,
    orch_frequency = "1 hour",
    slot_interval = "hour"
  )
}
}
