% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idRef.R
\name{idRef}
\alias{idRef}
\alias{idRef.singleJustifierElement}
\alias{idRef.multipleJustifierElements}
\alias{idRef.justifierIdRef}
\alias{idRef.character}
\alias{idRef.justifierStructured}
\title{Create a reference to one or more justifier objects}
\usage{
idRef(x, what = NULL, silent = justifier::opts$get("silent"))

\method{idRef}{singleJustifierElement}(x, what = NULL, silent = justifier::opts$get("silent"))

\method{idRef}{multipleJustifierElements}(x, what = NULL, silent = justifier::opts$get("silent"))

\method{idRef}{justifierIdRef}(x, what = NULL, silent = justifier::opts$get("silent"))

\method{idRef}{character}(x, what = NULL, silent = justifier::opts$get("silent"))

\method{idRef}{justifierStructured}(x, what = NULL, silent = justifier::opts$get("silent"))
}
\arguments{
\item{x}{The identifier(s)}

\item{what}{Optionally, what \code{x} is (\code{decision}, \code{justification},
\code{assertion}, or \code{source}).}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The justifier id reference object.
}
\description{
Create a reference to one or more justifier objects
}
\examples{
exampleSource <-
  justifier::source("This is a book about R.");

exampleAssertion <- justifier::assert(
  "R is a functional language",
  source = justifier::idRef(exampleSource)
);

### Get and show the reference
(sourceId <- exampleAssertion$source);

sourceId <- as.character(sourceId);

### Manually assign an identifier
justifier::idRef(sourceId);

### Repeat while specifying what we're passing
justifier::idRef(sourceId, what="source");
}
