% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld_clump.R
\name{ld_reflookup}
\alias{ld_reflookup}
\title{Check which rsids are present in a remote LD reference panel}
\usage{
ld_reflookup(rsid, pop = "EUR", opengwas_jwt = get_opengwas_jwt())
}
\arguments{
\item{rsid}{Array of rsids to check}

\item{pop}{Super-population to use as reference panel. Default = \code{"EUR"}.
Options are \code{"EUR"}, \code{"SAS"}, \code{"EAS"}, \code{"AFR"}, \code{"AMR"}}

\item{opengwas_jwt}{Used to authenticate protected endpoints. Login to \url{https://api.opengwas.io} to obtain a jwt. Provide the jwt string here, or store in .Renviron under the keyname OPENGWAS_JWT.}
}
\value{
Array of rsids that are present in the LD reference panel
}
\description{
Provide a list of rsids that you may want to perform LD operations on to
check if they are present in the LD reference panel. If they are not then
some functions e.g. \code{\link{ld_clump}} will exclude them from the analysis,
so you may want to consider how to handle those variants in your data.
}
