% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantileResiduals.R
\name{dlogmultistudent}
\alias{dlogmultistudent}
\title{Calculate logarithms of multiple multivariate Student's t densities with varying
 mean and covariance matrix of specific structure, but constant degrees of freedom.}
\usage{
dlogmultistudent(y, mu, inv_Omega, log_det_Omega, arch_scalars, df)
}
\arguments{
\item{y}{dimension \eqn{(T x k)} matrix where each row is a k-dimensional vector}

\item{mu}{dimension \eqn{(T x k)} matrix where each row is the mean of the k-dimensional
vector in corresponding row of \code{y}.}

\item{inv_Omega}{inverse of the \eqn{(k x k)} covariance matrix Omega.}

\item{log_det_Omega}{logarithm of the determinant of the covariance matrix Omega.}

\item{arch_scalars}{length \eqn{T} numeric vector containing the coefficients that multiply
the covariance matrix \code{Omega}.}

\item{df}{the degrees of freedom parameter that is common for all \eqn{t=1,...,T}.}
}
\value{
Returns a size \eqn{(T x 1)} vector containing the  multivariate Student's t
  densities in logarithm.
}
\description{
\code{dlogmultistudent} calculates logarithms of multiple multivariate
 Student's t densities with varying mean and covaraince matrix of specific structure.
}
\keyword{internal}
