% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{data_preparation}
\alias{data_preparation}
\alias{data_frame_to_list}
\alias{list_to_data_frame}
\title{Utility functions for data type conversion between data.frame and list.}
\usage{
data_frame_to_list(x)

list_to_data_frame(x)
}
\arguments{
\item{x}{A data.frame with logical columns representing sets, or a list of sets.}
}
\value{
A list of sets or a data.frame with logical columns representing sets.
}
\description{
Utility functions for data type conversion between data.frame and list.
}
\examples{
# Convert data.frame to list
d <- dplyr::tibble(name = 1:6,
            A = c(rep(TRUE, 5), FALSE),
            B = rep(c(FALSE, TRUE), each = 3))
print(d)
data_frame_to_list(d)

# Convert list to data.frame
a <- list(A = 1:5, B = 4:6)
print(a)
list_to_data_frame(a)

# Round-trip conversion
identical(a, data_frame_to_list(list_to_data_frame(a)))  # TRUE
identical(d, list_to_data_frame(data_frame_to_list(d)))  # TRUE
}
