% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/busca_por_cep.R
\name{busca_por_cep}
\alias{busca_por_cep}
\title{Busca por CEP}
\usage{
busca_por_cep(cep, resultado_sf = FALSE, verboso = TRUE, cache = TRUE)
}
\arguments{
\item{cep}{Vetor. Um CEP ou um vetor de CEPs com 8 dígitos.}

\item{resultado_sf}{Lógico. Indica se o resultado deve ser um objeto espacial
da classe \code{sf}. Por padrão, é \code{FALSE}, e o resultado é um \code{data.frame}.}

\item{verboso}{Um valor lógico. Indica se barras de progresso e mensagens
devem ser exibidas durante o download dos dados do CNEFE e a geocodificação
dos endereços. O padrão é \code{TRUE}.}

\item{cache}{Um valor lógico. Indica se os dados do CNEFE devem ser salvos ou
lidos do cache, reduzindo o tempo de processamento em chamadas futuras. O
padrão é \code{TRUE}. Quando \code{FALSE}, os dados do CNEFE são baixados para um
diretório temporário.}
}
\value{
Retorna um \code{data.frame} com os CEPs de input e os endereços presentes
naquele CEP com suas coordenadas geográficas de latitude (\code{lat}) e
longitude (\code{lon}). Alternativamente, o resultado pode ser um objeto \code{sf}.
}
\description{
Busca endereços e suas coordenadas geográficas a partir de um CEP. As
coordenadas de output utilizam o sistema de coordenadas geográficas SIRGAS
2000, EPSG 4674.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(geocodebr)

# amostra de CEPs
ceps <- c("70390-025", "20071-001", "99999-999")

df <- geocodebr::busca_por_cep(
  cep = ceps,
  verboso = FALSE
  )

df
\dontshow{\}) # examplesIf}
}
