% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_supports_rnd_write}
\alias{vsi_supports_rnd_write}
\title{Return whether the filesystem supports random write}
\usage{
vsi_supports_rnd_write(filename, allow_local_tmpfile)
}
\arguments{
\item{filename}{Character string. The path of the filesystem object to be
tested.}

\item{allow_local_tmpfile}{Logical scalar. \code{TRUE} if the filesystem is
allowed to use a local temporary file before uploading to the target
location.}
}
\value{
Logical scalar. \code{TRUE} if random write is supported.
}
\description{
\code{vsi_supports_rnd_write()} returns whether the filesystem supports
random write.
Wrapper for \code{VSISupportsRandomWrite()} in the GDAL API.
}
\note{
The location GDAL uses for temporary files can be forced via the
\code{CPL_TMPDIR} configuration option.
}
\examples{
# Requires GDAL >= 3.6
if (gdal_version_num() >= gdal_compute_version(3, 6, 0))
  vsi_supports_rnd_write("/vsimem/test-mem-file.gpkg", TRUE)
}
\seealso{
\code{\link[=vsi_supports_seq_write]{vsi_supports_seq_write()}}
}
