% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_focus_elements}
\alias{g6_focus_elements}
\title{Focus on specific elements in a g6 graph via proxy}
\usage{
g6_focus_elements(graph, ids, animation = NULL)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{ids}{Character vector containing the IDs of the elements (nodes/edges) to focus on.}

\item{animation}{Optional list containing animation configuration parameters for the focus action.
Common parameters include:
\itemize{
\item \code{duration}: Duration of the animation in milliseconds.
\item \code{easing}: Animation easing function name (e.g., "ease-in", "ease-out").
}
If NULL, no animation will be applied.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function focuses on one or more elements (nodes/edges) in an existing g6 graph instance
using a proxy object. It highlights the specified elements and can optionally
animate the view to focus on them.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

See \url{https://g6.antv.antgroup.com/en/api/element#graphfocuselementid-animation} for more details.
}
\seealso{
\code{\link{g6_proxy}}
}
