% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{compact_box_layout}
\alias{compact_box_layout}
\title{Generate G6 AntV Compact Box layout configuration}
\usage{
compact_box_layout(
  direction = c("LR", "RL", "TB", "BT", "H", "V"),
  getSide = NULL,
  getId = NULL,
  getWidth = NULL,
  getHeight = NULL,
  getHGap = NULL,
  getVGap = NULL,
  radial = FALSE,
  ...
)
}
\arguments{
\item{direction}{Layout direction: "LR" (left to right), "RL" (right to left),
"TB" (top to bottom), "BT" (bottom to top), "H" (horizontal), or "V" (vertical)}

\item{getSide}{Function to set the nodes to be arranged on the left/right side
of the root node. If not set, the algorithm automatically assigns the nodes
to the left/right side. Note: This parameter is only effective when the layout
direction is "H". Function format: \code{function(node) { return "left" or "right" }}}

\item{getId}{Callback function for generating node IDs.
Function format: \code{function(node) { return string }}}

\item{getWidth}{Function to calculate the width of each node.
Function format: \code{function(node) { return number }}}

\item{getHeight}{Function to calculate the height of each node.
Function format: \code{function(node) { return number }}}

\item{getHGap}{Function to calculate the horizontal gap for each node.
Function format: \code{function(node) { return number }}}

\item{getVGap}{Function to calculate the vertical gap for each node.
Function format: \code{function(node) { return number }}}

\item{radial}{Whether to enable radial layout}

\item{...}{Additional parameters to pass to the layout.
See \url{https://g6.antv.antgroup.com/en/manual/layout/compact-box-layout}.}
}
\value{
A list containing the configuration for G6 AntV Compact Box layout.
}
\description{
This function creates a configuration list for G6 AntV Compact Box layout
with all available options as parameters. The Compact Box layout is designed
for efficiently laying out trees and hierarchical structures.
}
\examples{
# Basic compact box layout
box_config <- compact_box_layout()

# Vertical compact box layout
box_config <- compact_box_layout(
  direction = "TB"
)

# Radial layout
box_config <- compact_box_layout(
  radial = TRUE
)
}
