% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_datasets.R
\docType{data}
\name{focal_vs_comp_ex}
\alias{focal_vs_comp_ex}
\title{Example focal versus comp data frame}
\format{
A \link[tibble:tbl_df-class]{tibble::tbl_df}:
\describe{
\item{focal_ID}{Tree identification number for the focal tree}
\item{focal_sp}{Species of the focal tree}
\item{dbh}{Diameter at breast height of the focal tree at the first census}
\item{foldID}{The CV-fold that the focal tree is in}
\item{geometry}{The point location of the focal tree}
\item{growth}{The average annual growth of the focal tree between censuses}
\item{comp}{A list-column: characteristics of the relevant competitor trees}
}

The \code{comp} list-column contains \link[tibble:tbl_df-class]{tibble::tbl_df}s with columns:
\describe{
\item{comp_ID}{Tree identification number for the competitor tree}
\item{dist}{The distance between the focal and comp tree, this will be less than the max distance specified.}
\item{comp_sp}{Species of the comp tree}
\item{comp_x_var}{Numerical variable associated with comp tree}
}
}
\usage{
focal_vs_comp_ex
}
\description{
This is an example focal versus comp data frame. The rows are focal
trees which are repeated for all competitor trees within a specified
distance from them. In this case that distance is 1. This is the focal
versus comp for \link{growth_spatial_ex}.
}
\examples{
comp_bayes_lm_ex <- focal_vs_comp_ex \%>\%
  comp_bayes_lm(prior_param = NULL, run_shuffle = FALSE)
}
\seealso{
\code{\link[=create_focal_vs_comp]{create_focal_vs_comp()}}

Other example data objects: 
\code{\link{blocks_ex}},
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{census_2_ex}},
\code{\link{comp_bayes_lm_ex}},
\code{\link{growth_ex}},
\code{\link{growth_spatial_ex}},
\code{\link{growth_toy}},
\code{\link{species_bw}},
\code{\link{study_region_bw}},
\code{\link{study_region_ex}}
}
\concept{example data objects}
\keyword{datasets}
