% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_comparison.R
\name{anova.modeler}
\alias{anova.modeler}
\title{Extra Sum-of-Squares F-Test for \code{modeler} objects}
\usage{
\method{anova}{modeler}(object, full_model = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{modeler} representing the
reduced model with fewer parameters.}

\item{full_model}{An optional object of class \code{modeler} representing
the full model with more parameters.}

\item{...}{Additional parameters for future functionality.}
}
\value{
A \code{tibble} containing columns with the F-statistic and
corresponding p-values, indicating whether the full model provides a
significantly better fit than the reduced model.
}
\description{
Perform an extra sum-of-squares F-test to compare two nested
models of class \code{modeler}. This test assesses whether the additional
parameters in the full model significantly improve the fit compared to the
reduced model.
}
\examples{
library(flexFitR)
dt <- data.frame(X = 1:6, Y = c(12, 16, 44, 50, 95, 100))
mo_1 <- modeler(dt, X, Y, fn = "fn_lin", param = c(m = 10, b = -5))
plot(mo_1)
mo_2 <- modeler(dt, X, Y, fn = "fn_quad", param = c(a = 1, b = 10, c = 5))
plot(mo_2)
anova(mo_1, mo_2)
}
\author{
Johan Aparicio [aut]
}
