% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-functions.R
\name{goodn_of_fit_test,fEGarch_fit-method}
\alias{goodn_of_fit_test,fEGarch_fit-method}
\title{Adjusted Pearson Goodness-of-Fit Test for Standardized Model Residuals}
\usage{
\S4method{goodn_of_fit_test}{fEGarch_fit}(object, n_bins = c(20, 30, 40, 50), silent = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{"fEGarch_fit"} as returned
by the fitting functions of this package like for example
\code{\link{fEGarch}}.}

\item{n_bins}{a numeric vector giving the number of bins to use.}

\item{silent}{a logical indicating whether or not to print
the test results in a well-formatted manner to the console.}

\item{...}{currently without purpose.}
}
\value{
Returns a numeric matrix invisibly.
}
\description{
Consider a probability integral transform on the
standardized residuals of a fitted model and apply a
Pearson goodness-of-fit test to the binned data using a
selection of predefined number of bins.
}
\details{
Use a probability integral transform on the
standardized residuals of a fitted model. This is then the
basis to conduct a Pearson goodness-of-fit chi-square test.
}
\examples{
window.zoo <- get("window.zoo", envir = asNamespace("zoo"))
rt <- window.zoo(SP500, end = "2002-12-31")
spec <- fEGarch_spec()
model <- fEGarch(spec, rt)
goodn_of_fit_test(model)

}
