% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-database.R
\name{eyeris_db_reconstruct_from_chunks}
\alias{eyeris_db_reconstruct_from_chunks}
\title{Reconstruct eyerisdb from chunked files}
\usage{
eyeris_db_reconstruct_from_chunks(
  chunked_dir,
  output_path,
  reconstruction_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{chunked_dir}{Directory containing the chunked database files and reconstruction metadata}

\item{output_path}{Full path for the reconstructed database (e.g., "/path/to/reconstructed.eyerisdb")}

\item{reconstruction_file}{Path to the reconstruction metadata JSON file. If NULL (default),
searches for "*_reconstruction_info.json" in chunked_dir}

\item{verbose}{Whether to print progress messages (default: TRUE)}
}
\value{
List containing information about the reconstruction process
}
\description{
Merges multiple chunked eyerisdb files back into a single database file.
Uses the reconstruction metadata file created by \code{eyeris_db_split_for_sharing()}
to ensure proper reconstruction.
}
\examples{
\dontrun{
# Reconstruct database from chunked files
reconstruction_info <- eyeris_db_reconstruct_from_chunks(
  chunked_dir = "/path/to/chunked_db/project-name",
  output_path = "/path/to/reconstructed-project.eyerisdb"
)

# Specify custom reconstruction file location
reconstruction_info <- eyeris_db_reconstruct_from_chunks(
  chunked_dir = "/path/to/chunked_db/project-name",
  output_path = "/path/to/reconstructed-project.eyerisdb",
  reconstruction_file = "/path/to/custom_reconstruction_info.json"
)
}

}
