% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_LRA.R, R/12_OrdinalLatentRank.R,
%   R/13_RatedLatentRank.R
\name{LRA}
\alias{LRA}
\alias{LRA.default}
\alias{LRA.binary}
\alias{LRA.ordinal}
\alias{LRA.rated}
\title{Latent Rank Analysis}
\usage{
LRA(U, ...)

\method{LRA}{default}(U, na = NULL, Z = Z, w = w, ...)

\method{LRA}{binary}(
  U,
  nrank = 2,
  method = "GTM",
  mic = FALSE,
  maxiter = 100,
  BIC.check = FALSE,
  seed = NULL,
  verbose = TRUE,
  ...
)

\method{LRA}{ordinal}(
  U,
  nrank = 2,
  mic = FALSE,
  maxiter = 100,
  trapezoidal = 0,
  eps = 1e-04,
  verbose = TRUE,
  ...
)

\method{LRA}{rated}(
  U,
  nrank = 2,
  mic = FALSE,
  maxiter = 100,
  trapezoidal = 0,
  eps = 1e-04,
  minFreqRatio = 0,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class with the \code{\link{dataFormat}} function.}

\item{...}{Additional arguments passed to specific methods.}

\item{na}{Values to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. 1 indicates observed values, 0 indicates missing values.}

\item{w}{Item weight vector.}

\item{nrank}{Number of latent ranks to estimate. Must be between 2 and 20.}

\item{method}{For binary data only. Either "SOM" (Self-Organizing Maps) or "GTM" (Gaussian Topographic Mapping). Default is "GTM".}

\item{mic}{Logical; if TRUE, forces Item Reference Profiles to be monotonically increasing. Default is FALSE.}

\item{maxiter}{Maximum number of iterations for estimation. Default is 100.}

\item{BIC.check}{For binary data with SOM method only. If TRUE, convergence is checked using BIC values. Default is FALSE.}

\item{seed}{For binary data with SOM method only. Random seed for reproducibility.}

\item{verbose}{Logical; if TRUE, displays detailed progress during estimation. Default is TRUE.}

\item{trapezoidal}{Specifies the height of both tails when using a trapezoidal
prior distribution. Must be less than 1/nrank. The default value is 0, which
results in a uniform prior distribution.}

\item{eps}{Convergence threshold for parameter updates. Default is 1e-4.}

\item{minFreqRatio}{Minimum frequency ratio for response categories (default = 0).
Categories with occurrence rates below this threshold will be excluded from analysis.
For example, if set to 0.1, response categories that appear in less than 10\% of
responses for an item will be omitted.}
}
\value{
A list of class "exametrika" and the specific subclass (e.g., "LRA", "LRAordinal", "LRArated")
containing the following common elements:
\describe{
\item{testlength}{Length of the test (number of items).}
\item{nobs}{Sample size (number of rows in the dataset).}
\item{Nrank}{Number of latent ranks specified.}
\item{N_Cycle}{Number of EM algorithm iterations performed.}
\item{TRP}{Test Reference Profile vector showing expected scores at each rank.}
\item{LRD}{Latent Rank Distribution vector showing the number of examinees at each rank.}
\item{RMD}{Rank Membership Distribution vector showing the sum of probabilities for each rank.}
\item{Students}{Rank Membership Profile matrix showing the posterior probabilities of
examinees belonging to each rank, along with their estimated ranks and odds ratios.}
\item{ItemFitIndices}{Fit indices for each item. See also \code{\link{ItemFit}}.}
\item{TestFitIndices}{Overall fit indices for the test. See also \code{\link{TestFit}}.}
}

Each subclass returns additional specific elements, detailed in their respective documentation.

For binary data (\code{LRA.binary}), the returned list additionally includes:
\describe{
\item{IRP}{Item Reference Profile matrix showing the probability of correct response for each item across different ranks.}
\item{IRPIndex}{Item Response Profile indices including the location parameters B and Beta,
slope parameters A and Alpha, and monotonicity indices C and Gamma.}
}

For ordinal data (\code{LRA.ordinal}), the returned list additionally includes:
\describe{
\item{ScoreReport}{Descriptive statistics of test performance, including sample size,
test length, central tendency, variability, distribution characteristics, and reliability.}
\item{ItemReport}{Basic statistics for each item including category proportions and item-total correlations.}
\item{ICBR}{Item Category Boundary Reference matrix showing cumulative probabilities for rank-category combinations.}
\item{ICRP}{Item Category Reference Profile matrix showing probability of response in each category by rank.}
\item{ScoreRankCorr}{Spearman's correlation between test scores and estimated ranks.}
\item{RankQuantCorr}{Spearman's correlation between estimated ranks and quantile groups.}
\item{ScoreRank}{Contingency table of raw scores by estimated ranks.}
\item{ScoreMembership}{Expected rank memberships for each raw score.}
\item{RankQuantile}{Cross-tabulation of rank frequencies and quantile groups.}
\item{MembQuantile}{Cross-tabulation of rank membership probabilities and quantile groups.}
\item{CatQuant}{Response patterns across item categories and quantile groups.}
}

For rated data (\code{LRA.rated}), the returned list additionally includes:
\describe{
\item{ScoreReport}{Descriptive statistics of test performance, including sample size,
test length, central tendency, variability, distribution characteristics, and reliability.}
\item{ItemReport}{Basic statistics for each item including category proportions and item-total correlations.}
\item{ICRP}{Item Category Reference Profile matrix showing probability of response in each category by rank.}
\item{ScoreRankCorr}{Spearman's correlation between test scores and estimated ranks.}
\item{RankQuantCorr}{Spearman's correlation between estimated ranks and quantile groups.}
\item{ScoreRank}{Contingency table of raw scores by estimated ranks.}
\item{ScoreMembership}{Expected rank memberships for each raw score.}
\item{RankQuantile}{Cross-tabulation of rank frequencies and quantile groups.}
\item{MembQuantile}{Cross-tabulation of rank membership probabilities and quantile groups.}
\item{ItemQuantileRef}{Reference values for each item across quantile groups.}
\item{CatQuant}{Response patterns across item categories and quantile groups.}
}
}
\description{
A general function for estimating Latent Rank Analysis across different response types.
This function automatically dispatches to the appropriate method based on the response type:

\itemize{
\item For binary data (\code{LRA.binary}): Analysis using either SOM or GTM method
\item For ordinal data (\code{LRA.ordinal}): Analysis using the GTM method with category thresholds
\item For rated data (\code{LRA.rated}): Analysis using the GTM method with rating categories
}

Latent Rank Analysis identifies underlying rank structures in test data and assigns
examinees to these ranks based on their response patterns.
}
\section{Binary Data Method}{

\code{LRA.binary} analyzes dichotomous (0/1) response data using either Self-Organizing Maps (SOM)
or Gaussian Topographic Mapping (GTM).
}

\section{Ordinal Data Method}{

\code{LRA.ordinal} analyzes ordered categorical data with multiple thresholds,
such as Likert-scale responses or graded items.
}

\section{Rated Data Method}{

\code{LRA.rated} analyzes data with ratings assigned to each response, such as
partially-credited items or preference scales where response categories have different weights.
}

\examples{
\donttest{
# Binary data example
# Fit a Latent Rank Analysis model with 6 ranks to binary data
result.LRA <- LRA(J15S500, nrank = 6)

# Display the first few rows of student rank membership profiles
head(result.LRA$Students)

# Plot Item Reference Profiles (IRP) for the first 6 items
plot(result.LRA, type = "IRP", items = 1:6, nc = 2, nr = 3)

# Plot Test Reference Profile (TRP) showing expected scores at each rank
plot(result.LRA, type = "TRP")
}

\donttest{
# Ordinal data example
# Fit a Latent Rank Analysis model with 3 ranks to ordinal data
result.LRAord <- LRA(J15S3810, nrank = 3, mic = TRUE)

# Plot score distributions
plot(result.LRAord, type = "ScoreFreq")
plot(result.LRAord, type = "ScoreRank")

# Plot category response patterns for items 1-6
plot(result.LRAord, type = "ICBR", items = 1:6, nc = 3, nr = 2)
plot(result.LRAord, type = "ICRP", items = 1:6, nc = 3, nr = 2)
}

\donttest{
# Rated data example
# Fit a Latent Rank Analysis model with 10 ranks to rated data
result.LRArated <- LRA(J35S5000, nrank = 10, mic = TRUE)

# Plot score distributions
plot(result.LRArated, type = "ScoreFreq")
plot(result.LRArated, type = "ScoreRank")

# Plot category response patterns for items 1-6
plot(result.LRArated, type = "ICRP", items = 1:6, nc = 3, nr = 2)
}

}
\seealso{
\code{\link{plot.exametrika}} for visualizing LRA results.
}
