% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_skewness}
\alias{find_skewness}
\title{Finding skewed variables}
\usage{
find_skewness(.data, index = TRUE, value = FALSE, thres = NULL)
}
\arguments{
\item{.data}{a data.frame or a \code{\link[tibble]{tbl_df}}.}

\item{index}{logical. When representing the information of a skewed variable,
specify whether or not the variable is represented by an index.
Returns an index if TRUE or a variable names if FALSE.}

\item{value}{logical. If TRUE, returns the skewness value
in the individual variable.}

\item{thres}{Returns a skewness threshold value that has an absolute skewness
greater than thres. The default is NULL to ignore the threshold.
but, If value = TRUE, default to 0.5.}
}
\value{
Information on variables including skewness.
}
\description{
Find the numerical variable that skewed variable
that inherits the data.frame or data.frame.
}
\examples{
find_skewness(heartfailure)

find_skewness(heartfailure, index = FALSE)

find_skewness(heartfailure, thres = 0.1)

find_skewness(heartfailure, value = TRUE)

find_skewness(heartfailure, value = TRUE, thres = 0.1)

## using dplyr -------------------------------------
library(dplyr)

# Perform simple data quality diagnosis of skewed variables
heartfailure \%>\%
  select(find_skewness(.)) \%>\%
  diagnose()
}
\seealso{
\code{\link{find_na}}, \code{\link{find_outliers}}.
}
