% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_RcppExports.R
\name{FIS}
\alias{FIS}
\title{(Fast) Fixed-Interval Smoother (Kalman Smoother)}
\usage{
FIS(A, F, F_pred, P, P_pred, F_0 = NULL, P_0 = NULL)
}
\arguments{
\item{A}{transition matrix (\eqn{rp \times rp}{rp x rp}).}

\item{F}{state estimates (\eqn{T \times rp}{T x rp}).}

\item{F_pred}{state predicted estimates (\eqn{T \times rp}{T x rp}).}

\item{P}{variance estimates (\eqn{rp \times rp \times T}{rp x rp x T}).}

\item{P_pred}{predicted variance estimates (\eqn{rp \times rp \times T}{rp x rp x T}).}

\item{F_0}{initial state vector (\eqn{rp \times 1}{rp x 1}) or empty (\code{NULL}).}

\item{P_0}{initial state covariance (\eqn{rp \times rp}{rp x rp}) or empty (\code{NULL}).}
}
\value{
Smoothed state and covariance estimates, including initial (t = 0) values.
\item{\code{F_smooth}}{\eqn{T \times rp}{T x rp} smoothed state vectors, equal to the filtered state in period \eqn{T}.}
\item{\code{P_smooth}}{\eqn{rp \times rp \times T}{rp x rp x T} smoothed state covariance, equal to the filtered covariance in period \eqn{T}.}
\item{\code{F_smooth_0}}{\eqn{1 \times rp}{1 x rp} initial smoothed state vectors, based on \code{F_0}.}
\item{\code{P_smooth_0}}{\eqn{rp \times rp}{rp x rp} initial smoothed state covariance, based on \code{P_0}.}
}
\description{
(Fast) Fixed-Interval Smoother (Kalman Smoother)
}
\details{
The Kalman Smoother is given by:

\deqn{\textbf{J}_t = \textbf{P}_t \textbf{A} + inv(\textbf{P}^{pred}_{t+1})}{J(t) = P(t) A inv(P_pred(t+1))}
\deqn{\textbf{F}^{smooth}_t = \textbf{F}_t + \textbf{J}_t (\textbf{F}^{smooth}_{t+1} - \textbf{F}^{pred}_{t+1})}{F_smooth(t) = F(t) + J(t) (F_smooth(t+1) - F_pred(t+1))}
\deqn{\textbf{P}^{smooth}_t = \textbf{P}_t + \textbf{J}_t (\textbf{P}^{smooth}_{t+1} - \textbf{P}^{pred}_{t+1}) \textbf{J}_t'}{P_smooth(t) = P(t) + J(t) (P_smooth(t+1) - P_pred(t+1)) J(t)'}

The initial smoothed values for period t = T are set equal to the filtered values. If \code{F_0} and \code{P_0} are supplied, the smoothed initial conditions (t = 0 values) are also calculated and returned.
For further details see any textbook on time series such as Shumway & Stoffer (2017), which provide an analogous R implementation in \code{astsa::Ksmooth0}.
}
\examples{
# See ?SKFS

}
\references{
Shumway, R. H., & Stoffer, D. S. (2017). Time Series Analysis and Its Applications: With R Examples. Springer.

Harvey, A. C. (1990). Forecasting, structural time series models and the Kalman filter.
}
\seealso{
\code{\link{SKF}} \code{\link{SKFS}} \link{dfms-package}
}
