% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{drug_exp_prop}
\alias{drug_exp_prop}
\title{Drug Experimental Properties parser}
\usage{
drug_exp_prop()
}
\value{
a tibble with the following variables:
\describe{
 \item{kind}{Name of the property.}
 \item{value}{Drug properties that have been experimentally proven.}
 \item{source}{Reference to the source of this experimental data.}
 \item{\emph{drugbank_id}}{drugbank id}
}

The following experimental properties are provided:
\describe{
 \item{Water Solubility}{The experimentally determined aqueous solubility
 of the molecule.}
 \item{Molecular Formula}{Protein formula of Biotech drugs}
 \item{Molecular Weight}{Protein weight of Biotech drugs.}
 \item{Melting Point}{The experimentally determined temperature at which the
  drug molecule changes from solid to liquid at atmospheric temperature.}
 \item{Boiling Point}{The experimentally determined temperature at which the
  drug molecule changes from liquid to gas at atmospheric temperature.}
 \item{Hydrophobicity}{The ability of a molecule to repel water rather than
 absorb or dissolve water.}
 \item{Isoelectric Point}{The pH value at which the net electric charge of a
 molecule is zero.}
 \item{caco2 Permeability}{A continuous line of heterogenous human epithelial
  colorectal adenocarcinoma cells, CAC02 cells are employed as a model of
  human intestinal absorption of various drugs and compounds. CAC02 cell
  permeability is ultimately an assay to measure drug absorption.}
 \item{pKa}{The experimentally determined pka value of the molecule}
 \item{logP}{The experimentally determined partition coefficient (LogP)
 based on the ratio of solubility of the molecule in 1-octanol compared to
 water.}
 \item{logS}{The intrinsic solubility of a given compound is the
 concentration in equilibrium with its solid phase that dissolves into
  solution, given as the natural logarithm (LogS) of the concentration.}
 \item{Radioactivity}{The property to spontaneously emit particles
 (alpha, beta, neutron) or radiation (gamma, K capture), or both at the same
 time, from the decay of certain nuclides.}
}
}
\description{
Drug properties that have been experimentally proven
}
\keyword{internal}
